package com.bawnorton.bettertrims.mixin.property.ability.projectile;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimEntityAbilityRunner;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1676.class)
abstract class ProjectileMixin extends class_1297 {
	ProjectileMixin(class_1299<?> entityType, class_1937 level) {
		super(entityType, level);
	}

	@Shadow
	@Nullable
	public abstract class_1297 getOwner();

	@Inject(
			method = "tick",
			at = @At("HEAD")
	)
	private void applyTrimsToProjectileTick(CallbackInfo ci) {
		if (!(getOwner() instanceof class_1309 wearer) || !(method_73183() instanceof class_3218 level)) return;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (TrimEntityAbilityRunner<?> ability : property.getEntityAbilityRunners(TrimAbilityComponents.PROJECTILE_TICK)) {
				ability.runTick(level, wearer, this, method_73189());
			}
		}
	}
}
