package com.bawnorton.bettertrims.mixin.property.item_property.damage_immunity;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1297.class)
abstract class EntityMixin {
	@Shadow
	private class_1937 level;

	@SuppressWarnings("ConstantValue")
	@ModifyReturnValue(
			//? if >=1.21.8 {
			method = "isInvulnerableToBase",
			//?} else {
			/*method = "isInvulnerableTo",
			*///?}
			at = @At("RETURN")
	)
	private boolean isTrimInvulnerableTo(boolean original, class_1282 damageSource) {
		if (original) return true;
		if (!((Object) this instanceof class_1542 itemEntity)) return false;
		if (!(level instanceof class_3218 serverLevel)) return false;

		class_1799 stack = itemEntity.method_6983();
		for (TrimProperty property : TrimProperties.getProperties(serverLevel)) {
			for (ElementMatcher<?> elementMatcher : property.getItemPropertyElements(TrimItemPropertyComponents.DAMAGE_IMMUNITY)) {
				if (elementMatcher.matches(stack, TrimContexts.damageItem(serverLevel, stack, itemEntity, damageSource))) {
					return true;
				}
			}
		}
		return false;
	}
}
