package com.bawnorton.bettertrims.property;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.*;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

public final class Matcher {
	public static final Codec<Matcher> CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_6898.method_40388(class_7924.field_42083, class_8054.field_42003, false)
					.optionalFieldOf("material", class_6885.method_58563())
					.forGetter(Matcher::material),
			class_6898.method_40388(class_7924.field_42082, class_8056.field_42015, false)
					.optionalFieldOf("pattern", class_6885.method_58563())
					.forGetter(Matcher::pattern),
			class_5699.method_48766(1, 255)
					.optionalFieldOf("min_count", 1)
					.forGetter(Matcher::minCount)
	).apply(instance, Matcher::new));

	private final class_6885<class_8054> material;
	private final class_6885<class_8056> pattern;
	private final int minCount;

	private final Map<class_8053, Boolean> matchingCache = new WeakHashMap<>();

	public Matcher(class_6885<class_8054> material, class_6885<class_8056> pattern, int minCount) {
		this.material = material;
		this.pattern = pattern;
		this.minCount = minCount;
	}

	public static Matcher forMaterial(class_6885<class_8054> material, int minCount) {
		return new Matcher(material, class_6885.method_58563(), minCount);
	}

	public static Matcher forPattern(class_6885<class_8056> pattern, int minCount) {
		return new Matcher(class_6885.method_58563(), pattern, minCount);
	}

	public Map<class_1304, class_1799> getMatchingStacks(class_1309 wearer) {
		Map<class_1304, class_1799> stacks = new HashMap<>();
		for (class_1304 slot : class_1304.values()) {
			class_1799 stack = wearer.method_6118(slot);
			class_1304 shouldBeInSlot = wearer.method_32326(stack);
			if (slot != shouldBeInSlot) continue;

			if (matches(stack)) {
				stacks.put(slot, stack);
			}
		}
		return stacks;
	}

	public boolean matches(class_1309 wearer, class_1799 stack, class_1304 slot) {
		class_1304 shouldBeInSlot = wearer.method_32326(stack);
		return shouldBeInSlot == slot && matches(stack);
	}

	public boolean matches(class_1799 stack) {
		class_8053 trim = stack.method_58694(class_9334.field_49607);
		if (trim == null) return false;

		return matches(trim);
	}

	public boolean matches(class_8053 trim) {
		if(matchingCache.containsKey(trim)) {
			return matchingCache.get(trim);
		}

		class_6880<class_8054> material = trim.comp_3179();
		class_6880<class_8056> pattern = trim.comp_3180();
		boolean matchesMaterial = this.material.method_40241(material) || (!(this.material instanceof class_6885.class_6888) && this.material.method_40247() == 0);
		boolean matchesPattern = this.pattern.method_40241(pattern) || (!(this.pattern instanceof class_6885.class_6888) && this.pattern.method_40247() == 0);
		boolean result = matchesMaterial && matchesPattern;
		matchingCache.put(trim, result);
		return result;
	}

	public class_6885<class_8054> material() {
		return material;
	}

	public class_6885<class_8056> pattern() {
		return pattern;
	}

	public int minCount() {
		return minCount;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) return true;
		if (obj == null || obj.getClass() != this.getClass()) return false;
		var that = (Matcher) obj;
		return Objects.equals(this.material, that.material) &&
				Objects.equals(this.pattern, that.pattern) &&
				this.minCount == that.minCount;
	}

	@Override
	public int hashCode() {
		return Objects.hash(material, pattern, minCount);
	}

	@Override
	public String toString() {
		return "Matcher[" +
				"material=" + material + ", " +
				"pattern=" + pattern + ", " +
				"minCount=" + minCount + ']';
	}
}