package com.bawnorton.bettertrims.property.ability;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.element.ConditionalElement;
import com.bawnorton.bettertrims.property.context.TrimContextParamSets;
import com.bawnorton.bettertrims.property.ability.type.misc.DamageImmunityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9323;
import net.minecraft.class_9331;

public interface TrimAbilityComponents {
	Codec<class_9331<?>> COMPONENT_CODEC = Codec.lazyInitialized(BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE::method_39673);

	Codec<class_9323> CODEC = class_9323.method_60386(COMPONENT_CODEC);

	Map<class_2960, class_2561> TOOLTIPS = new HashMap<>();

	class_9331<List<ConditionalElement<TrimValueAbility>>> INCOMING_DAMAGE = register(
			"incoming_damage",
			builder -> builder.method_57881(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf())
	);
	class_9331<List<ConditionalElement<DamageImmunityAbility>>> DAMAGE_IMMUNITY = register(
			"damage_immunity",
			builder -> builder.method_57881(ConditionalElement.ability(DamageImmunityAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf())
	);
	class_9331<List<ConditionalElement<TrimValueAbility>>> DAMAGE = register(
			"damage",
			builder -> builder.method_57881(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf())
	);
	class_9331<List<ConditionalElement<TrimValueAbility>>> ARMOUR_EFFECTIVENESS = register(
			"armour_effectiveness",
			builder -> builder.method_57881(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf())
	);
	class_9331<List<ConditionalElement<TrimEntityAbility>>> POST_ATTACK = register(
			"post_attack",
			builder -> builder.method_57881(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf())
	);
	class_9331<List<ConditionalElement<TrimEntityAbility>>> HIT_BLOCK = register(
			"hit_block",
			builder -> builder.method_57881(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.HIT_BLOCK_WITH_HELD_ITEM).listOf())
	);
	class_9331<List<ConditionalElement<TrimValueAbility>>> ITEM_DAMAGE = register(
			"item_damage",
			builder -> builder.method_57881(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf())
	);
	class_9331<List<ConditionalElement<TrimToggleAbility>>> EQUIPPED = register(
			"equipped",
			builder -> builder.method_57881(ConditionalElement.ability(TrimToggleAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf())
	);
	class_9331<List<ConditionalElement<TrimEntityAbility>>> TICK = register(
			"tick",
			builder -> builder.method_57881(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf())
	);
	class_9331<List<ConditionalElement<TrimEntityAbility>>> SECOND = register(
			"second",
			builder -> builder.method_57881(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf())
	);
	class_9331<List<ConditionalElement<TrimEntityAbility>>> PROJECTILE_TICK = register(
			"projectile_tick",
			builder -> builder.method_57881(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf())
	);
	class_9331<List<ConditionalElement<TrimValueAbility>>> EXPERIENCE_GAINED = register(
			"experience_gained",
			builder -> builder.method_57881(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf())
	);
	class_9331<List<ConditionalElement<TrimValueAbility>>> TRADE_COST = register(
			"trade_cost",
			builder -> builder.method_57881(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf())
	);
	class_9331<List<ConditionalElement<PiglinSafeAbility>>> PIGLIN_SAFE = register(
			"piglin_safe",
			builder -> builder.method_57881(ConditionalElement.ability(PiglinSafeAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf())
	);

	private static <T> class_9331<T> register(String name, UnaryOperator<class_9331.class_9332<T>> operator) {
		class_2960 id = BetterTrims.rl(name);
		TOOLTIPS.put(id, class_2561.method_43471("bettertrims.tooltip.component." + name));
		return class_2378.method_10230(
				BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE,
				id,
				operator.apply(class_9331.method_57873()).method_57880()
		);
	}

	static class_9331<?> bootstrap(class_2378<class_9331<?>> ignored) {
		return PIGLIN_SAFE;
	}
}
