package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5684;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_638;
import net.minecraft.class_9734;
import org.jetbrains.annotations.Nullable;

public record SpawnParticlesAbility(
		class_2394 particle,
		class_9734.class_9735 horizontalPosition,
		class_9734.class_9735 verticalPosition,
		class_9734.class_9738 horizontalVelocity,
		class_9734.class_9738 verticalVelocity,
		class_5863 speed
) implements TrimEntityAbility {
	public static final MapCodec<SpawnParticlesAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			class_2398.field_25125.fieldOf("particle").forGetter(SpawnParticlesAbility::particle),
			class_9734.class_9735.field_51722.fieldOf("horizontal_position").forGetter(SpawnParticlesAbility::horizontalPosition),
			class_9734.class_9735.field_51722.fieldOf("vertical_position").forGetter(SpawnParticlesAbility::verticalPosition),
			class_9734.class_9738.field_51729.fieldOf("horizontal_velocity").forGetter(SpawnParticlesAbility::horizontalVelocity),
			class_9734.class_9738.field_51729.fieldOf("vertical_velocity").forGetter(SpawnParticlesAbility::verticalVelocity),
			class_5863.field_29007.optionalFieldOf("speed", class_5862.field_29003).forGetter(SpawnParticlesAbility::speed)
	).apply(instance, SpawnParticlesAbility::new));

	@Override
	public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
		class_5819 random = target.method_59922();
		class_243 targetVelocity = target.method_60478();
		float width = target.method_17681();
		float height = target.method_17682();
		level.method_65096(
				this.particle,
				this.horizontalPosition.method_60254(origin.method_10216(), origin.method_10216(), width, random),
				this.verticalPosition.method_60254(origin.method_10214(), origin.method_10214() + height / 2.0F, height, random),
				this.horizontalPosition.method_60254(origin.method_10215(), origin.method_10215(), width, random),
				0,
				this.horizontalVelocity.method_60262(targetVelocity.method_10216(), random),
				this.verticalVelocity.method_60262(targetVelocity.method_10214(), random),
				this.horizontalVelocity.method_60262(targetVelocity.method_10215(), random),
				this.speed.method_33920(random)
		);
	}

	@Override
	public MapCodec<? extends TrimEntityAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<SpawnParticlesAbility> {
		@Nullable
		@Override
		public class_5684 getTooltip(class_638 level, SpawnParticlesAbility element, boolean includeCount) {
			class_2561 particleName = getParticleName(level, element);
			if (particleName == null) return null;
			return CompositeContainerComponent.builder()
					.translate("bettertrims.tooltip.ability.spawn_particles.spawns", Styler::positive)
					.textComponent(particleName)
					.translate("bettertrims.tooltip.ability.spawn_particles.particles", Styler::positive)
					.spaced()
					.build();
		}

		private static @Nullable class_2561 getParticleName(class_638 level, SpawnParticlesAbility element) {
			return switch (element.particle()) {
				case BlockParticleOption blockParticle -> {
					BlockState state = blockParticle.getState();
					MutableComponent blockName = state.getBlock().getName();
					yield Styler.positive(Component.translatable("bettertrims.tooltip.ability.spawn_particles.block", Styler.name(blockName)));
				}
				default -> {
					Registry<ParticleType<?>> registry = VRegistry.get(level, Registries.PARTICLE_TYPE);
					ResourceLocation particleType = registry.getKey(element.particle().getType());
					if (particleType == null) yield null;

					yield Styler.name(Component.literal(particleType.toString()));
				}
			};
		}
	}
}
