package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public record SummonEntityAbility(class_1299<?> entityType) implements TrimEntityAbility {
	public static final MapCodec<SummonEntityAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			class_7923.field_41177.method_39673().fieldOf("entity").forGetter(SummonEntityAbility::entityType)
	).apply(instance, SummonEntityAbility::new));

	@Override
	public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
		class_2338 blockPos = class_2338.method_49638(origin);
		if (!class_1937.method_25953(blockPos)) return;

		class_1297 entity = entityType.method_47821(level, blockPos, class_3730.field_16461);
		if (entity == null) return;

		if (entity instanceof class_1538 lightningBolt && wearer instanceof class_3222 player) {
			lightningBolt.method_6961(player);
		}
		entity.method_5808(origin.method_10216(), origin.method_10214(), origin.method_10215(), entity.method_36454(), entity.method_36455());
	}

	@Override
	public MapCodec<? extends TrimEntityAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<SummonEntityAbility> {
		@Nullable
		@Override
		public class_5684 getTooltip(class_638 level, SummonEntityAbility element, boolean includeCount) {
			return CompositeContainerComponent.builder()
					.translate(
							"bettertrims.tooltip.ability.summon_entity",
							Styler::positive,
							Styler.name(element.entityType().method_5897().method_27661())
					)
					.build();
		}
	}
}
