package com.bawnorton.bettertrims.property.element;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_176;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_58;
import net.minecraft.class_8942;

public record ConditionalElement<T extends TrimElement>(T element, Optional<class_5341> requirements) {
	public static Codec<class_5341> conditionCodec(class_176 contextKeySet) {
		return class_5341.field_51809
				.validate(
						lootItemCondition -> {
							class_8942.class_8943 collector = new class_8942.class_8943();
							class_58 validationContext = new class_58(collector, contextKeySet);
							lootItemCondition.method_292(validationContext);
							//? if >=1.21.8 {
							return collector.method_71349() ?
									DataResult.success(lootItemCondition) :
									DataResult.error(() -> "Validation error in trim element condition: " + collector.method_59906());
							//?} else {
							/*return collector.getReport()
									.map(string -> DataResult.<LootItemCondition>error(() -> "Validation error in trim element condition: " + string))
									.orElseGet(() -> DataResult.success(lootItemCondition));
							*///?}
						}
				);
	}

	public static <T extends TrimElement> Codec<ConditionalElement<T>> ability(Codec<T> codec, class_176 contextKeySet) {
		return RecordCodecBuilder.create(instance -> instance.group(
				codec.fieldOf("ability").forGetter(ConditionalElement::element),
				conditionCodec(contextKeySet).optionalFieldOf("requirements").forGetter(ConditionalElement::requirements)
		).apply(instance, ConditionalElement::new));
	}

	public static <T extends TrimElement> Codec<ConditionalElement<T>> itemProperty(Codec<T> codec, class_176 contextKeySet) {
		return RecordCodecBuilder.create(instance -> instance.group(
				codec.fieldOf("item_property").forGetter(ConditionalElement::element),
				conditionCodec(contextKeySet).optionalFieldOf("requirements").forGetter(ConditionalElement::requirements)
		).apply(instance, ConditionalElement::new));
	}

	public boolean matches(class_47 context) {
		return requirements.map(condition -> condition.test(context)).orElse(true);
	}
}
