package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.BetterTrimsClient;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ItemComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.element.ConditionalElement;
import com.bawnorton.bettertrims.property.element.ConditionalElementMatcher;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.bawnorton.bettertrims.version.VRegistry;
import com.bawnorton.bettertrims.version.VTrims;
import it.unimi.dsi.fastutil.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5341;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class TrimTooltipPage {
	private final Matcher matcher;
	private final TrimProperty property;
	private class_5684 component;

	public TrimTooltipPage(TrimProperty property, Matcher matcher) {
		this.matcher = matcher;
		this.property = property;
	}

	private static class_5684 generateAsItemHeader() {
		return CompositeContainerComponent.builder()
				.translate("bettertrims.tooltip.properties.as_item", Styler::normal)
				.build();
	}

	private static @NotNull List<class_1799> getPatternProviders(List<class_8056> patterns, class_638 level) {
		List<class_1799> patternProviders = new ArrayList<>();
		for (Map.Entry<class_6880<class_8056>, class_6885<class_1792>> entry : BetterTrimsClient.getPatternSources().entrySet()) {
			class_6880<class_8056> patternHolder = entry.getKey();
			class_8056 pattern = patternHolder.method_40229()
					//? if >=1.21.8 {
					/*.map(key -> VRegistry.get(level, Registries.TRIM_PATTERN).getValueOrThrow(key), Function.identity());
					 *///?} else {
					.map(key -> VRegistry.get(level, class_7924.field_42082).method_31140(key), Function.identity());
			//?}
			if (patterns.contains(pattern)) {
				class_6885<class_1792> itemHolders = entry.getValue();
				patternProviders.addAll(itemHolders.method_40239()
						.map(holder -> holder.method_40229()
								//? if >=1.21.8 {
								/*.map(key -> VRegistry.get(level, Registries.ITEM).getValueOrThrow(key), Function.identity()))
								 *///?} else {
								.map(key -> VRegistry.get(level, class_7924.field_41197).method_31140(key), Function.identity()))
						//?}
						.map(class_1792::method_7854)
						.toList());
			}
		}
		return patternProviders;
	}

	public static class_5684 generateMatcherComponent(class_638 level, class_6885<class_8054> materials, class_6885<class_8056> patterns) {
		List<class_8054> materialList = materials.method_40239().map(class_6880::comp_349).toList();
		List<class_8056> patternList = patterns.method_40239().map(class_6880::comp_349).toList();
		if (materialList.isEmpty()) {
			return generateAnyMaterialComponent(patternList, level);
		} else if (patternList.isEmpty()) {
			return generateAnyPatternComponent(materialList, level);
		} else {
			return generateSpecificMaterialPatternComponent(patternList, materialList, level);
		}
	}

	private static class_5684 generateAnyMaterialComponent(List<class_8056> patterns, class_638 level) {
		if (patterns.isEmpty()) {
			return generateAnyMaterialOrPatternComponent(level);
		}

		return generateMatcherComponentFor(getAllMaterialProviders(level), getPatternProviders(patterns, level));
	}

	private static class_5684 generateAnyPatternComponent(List<class_8054> materials, class_638 level) {
		if (materials.isEmpty()) {
			return generateAnyMaterialOrPatternComponent(level);
		}

		return generateMatcherComponentFor(getMaterialProviders(materials, level), getAllPatternProviders(level));
	}

	private static class_5684 generateAnyMaterialOrPatternComponent(class_638 level) {
		return generateMatcherComponentFor(getAllMaterialProviders(level), getAllPatternProviders(level));
	}

	private static class_5684 generateSpecificMaterialPatternComponent(List<class_8056> patterns, List<class_8054> materials, class_638 level) {
		return generateMatcherComponentFor(getMaterialProviders(materials, level), getPatternProviders(patterns, level));
	}

	private static class_5684 generateMatcherComponentFor(List<class_1799> materialProviders, List<class_1799> patternProviders) {
		return CompositeContainerComponent.builder()
				.cycle(builder -> materialProviders.stream().map(ItemComponent::new).forEach(builder::component))
				.literal("-", Styler::trim)
				.cycle(builder -> patternProviders.stream().map(ItemComponent::new).forEach(builder::component))
				.spaced()
				.centred(true)
				.build();
	}

	private static List<class_1799> getMaterialProviders(List<class_8054> materials, class_638 level) {
		return getAllMaterialProviders(level)
				.stream()
				.filter(item -> {
					class_8054 material = VTrims.getMaterialFromStack(level, item);
					return material != null && materials.contains(material);
				})
				.toList();
	}

	private static List<class_1799> getAllMaterialProviders(class_638 level) {
		return VRegistry.get(level, class_7924.field_41197)
				.method_10220()
				.map(class_1792::method_7854)
				.filter(stack -> VTrims.getMaterialFromStack(level, stack) != null)
				.toList();
	}

	private static List<class_1799> getAllPatternProviders(class_638 level) {
		return BetterTrimsClient.getPatternSources()
				.values()
				.stream()
				.map(class_6885::method_40239)
				.flatMap(stream -> stream.map(holder -> holder.method_40229()
						//? if >=1.21.8 {
						/*.map(key -> VRegistry.get(level, Registries.ITEM).getValueOrThrow(key), Function.identity())))
						 *///?} else {
						.map(key -> VRegistry.get(level, class_7924.field_41197).method_31140(key), Function.identity())))
				//?}
				.map(class_1792::method_7854)
				.toList();
	}

	public class_5684 getComponent() {
		if (component == null) {
			throw new IllegalStateException("Components have not been generated yet");
		}
		return component;
	}

	@SuppressWarnings("unchecked")
	public void generateComponent(class_638 level, class_327 font, int index, int total) {
		component = null;

		CompositeContainerComponent.Builder pageBuilder = CompositeContainerComponent.builder().vertical();
		pageBuilder.component(generateTitle(level, index, total));

		boolean addHeader = true;
		boolean hasAbilities = false;
		for (class_9331<?> type : BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE) {
			class_9331<List<ConditionalElement<TrimElement>>> castType = (class_9331<List<ConditionalElement<TrimElement>>>) type;
			CompositeContainerComponent abilityComponent = generateAbilityTooltipComponent(level, font, castType);
			if (abilityComponent == null) continue;

			hasAbilities = true;
			if (addHeader) {
				pageBuilder.component(generateWearingAbilityHeader(level));
				addHeader = false;
			}

			class_2561 typeTooltip = TrimAbilityComponents.TOOLTIPS.get(BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE.method_10221(type));
			generateElementComponent(pageBuilder, abilityComponent, typeTooltip);
		}

		addHeader = true;
		for (class_9331<?> type : BetterTrimsRegistries.TRIM_ITEM_PROPERTY_COMPONENT_TYPE) {
			class_9331<List<ConditionalElement<TrimElement>>> castType = (class_9331<List<ConditionalElement<TrimElement>>>) type;
			CompositeContainerComponent itemPropertyComponent = generateItemPropertyTooltipComponent(level, font, castType);
			if (itemPropertyComponent == null) continue;

			if (hasAbilities) {
				pageBuilder.space();
			}
			if (addHeader) {
				pageBuilder.component(generateAsItemHeader());
				addHeader = false;
			}

			class_2561 typeTooltip = TrimItemPropertyComponents.TOOLTIPS.get(BetterTrimsRegistries.TRIM_ITEM_PROPERTY_COMPONENT_TYPE.method_10221(type));
			generateElementComponent(pageBuilder, itemPropertyComponent, typeTooltip);
		}

		CompositeContainerComponent page = pageBuilder.build();
		component = TooltipComponentOptimiser.optimise(page, font);
	}

	private void generateElementComponent(CompositeContainerComponent.Builder pageBuilder, CompositeContainerComponent elementComponent, class_2561 typeTooltip) {
		if (typeTooltip == null) {
			typeTooltip = class_2561.method_43471("bettertrims.tooltip.component.unknown");
		}

		CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder()
				.vertical()
				.component(CompositeContainerComponent.builder()
						.space()
						.textComponent(Styler.component(typeTooltip.method_27661()))
						.build());
		if (!elementComponent.isEmpty()) {
			builder.component(CompositeContainerComponent.builder()
					.space()
					.space()
					.component(elementComponent)
					.build());
		}
		pageBuilder.component(builder.build());
	}

	public int getRenderedWidth(class_327 font) {
		return DynamicWidthComponent.getMaxWidth(font, component, 0);
	}

	private class_5684 generateTitle(class_638 level, int index, int total) {
		class_2960 propertyId = VRegistry.get(level, BetterTrimsRegistries.Keys.TRIM_PROPERTIES).method_10221(property);
		if (propertyId == null) {
			BetterTrims.LOGGER.warn("Property {} does not have a registry name", property);
			propertyId = BetterTrims.rl("unknown");
		}
		CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder()
				.translate("bettertrims.property.%s.%s".formatted(propertyId.method_12836(), propertyId.method_12832()), Styler::trim)
				.space()
				.literal("(", Styler::trim)
				.component(generateMatcherComponent(level, matcher.material(), matcher.pattern()))
				.literal(")", Styler::trim)
				.centred(true);
		if (total > 1) {
			builder.literal(" - [" + (index + 1) + "/" + total + "]", Styler::trim);
		}
		return builder.build();
	}

	private CompositeContainerComponent generateAbilityTooltipComponent(class_638 level, class_327 font, class_9331<List<ConditionalElement<TrimElement>>> type) {
		List<ConditionalElementMatcher<?>> elements = property.getAbilityElements(type);
		if (elements.isEmpty()) return null;

		CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder()
				.vertical();
		for (ConditionalElementMatcher<?> element : elements) {
			builder.component(getTooltipFromConditionalElement(level, font, element.getConditionalElement()));
		}
		return builder.build();
	}

	private CompositeContainerComponent generateItemPropertyTooltipComponent(class_638 level, class_327 font, class_9331<List<ConditionalElement<TrimElement>>> castType) {
		List<ConditionalElementMatcher<?>> elements = property.getItemPropertyElements(castType);
		if (elements.isEmpty()) return null;

		CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder()
				.vertical();
		for (ConditionalElementMatcher<?> element : elements) {
			builder.component(getTooltipFromConditionalElement(level, font, element.getConditionalElement()));
		}
		return builder.build();
	}

	private class_5684 getTooltipFromConditionalElement(class_638 level, class_327 font, ConditionalElement<?> conditionalElement) {
		TrimElement element = conditionalElement.element();
		Optional<class_5341> requirements = conditionalElement.requirements();
		CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
		requirements.map(condition -> LootConditionTooltips.getTooltip(level, font, condition)).ifPresent(builder::component);
		TrimElementTooltipProvider<TrimElement> provider = TrimElementTooltips.getProvider(element.getClass());
		class_5684 tooltip = provider.getTooltip(level, element, true);
		if (tooltip != null) {
			builder.component(tooltip);
		}
		return builder.build();
	}

	private class_5684 generateWearingAbilityHeader(class_638 level) {
		int minCount = matcher.minCount();
		List<CyclingComponent> trimmedItems = new ArrayList<>();
		class_6885<class_8054> materials = matcher.material();
		if (materials.method_40247() == 0) {
			materials = class_6885.method_40242(getAllMaterialProviders(level).stream()
					.map(stack -> class_6880.method_40223(VTrims.getMaterialFromStack(level, stack)))
					.toList());
		}
		class_6885<class_8056> patterns = matcher.pattern();
		if (patterns.method_40247() == 0) {
			patterns = class_6885.method_40242(BetterTrimsClient.getPatternSources().keySet().stream().toList());
		}
		List<Pair<class_6880<class_8056>, class_6880<class_8054>>> pairs = new ArrayList<>();
		for (class_6880<class_8054> material : materials) {
			for (class_6880<class_8056> pattern : patterns) {
				pairs.add(Pair.of(pattern, material));
			}
		}
		for (Pair<class_6880<class_8056>, class_6880<class_8054>> pair : pairs) {
			List<class_1799> items = new ArrayList<>();
			for (class_1792 item : List.of(class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660)) {
				class_8053 trim = new class_8053(pair.right(), pair.left());
				class_1799 stack = item.method_7854();
				stack.method_57379(class_9334.field_49607, trim);
				items.add(stack);
			}

			CyclingComponent.Builder builder = CyclingComponent.builder();
			items.stream().map(ItemComponent::new).forEach(builder::component);
			trimmedItems.add(builder.build());
		}

		return switch (minCount) {
			case 4 -> CompositeContainerComponent.builder()
					.translate("bettertrims.tooltip.properties.count.all_of", Styler::normal)
					.stack(trimmedItems, 16)
					.translate("bettertrims.tooltip.properties.count.equipped", Styler::normal)
					.spaced()
					.centred(true)
					.build();
			case 1 -> CompositeContainerComponent.builder()
					.translate("bettertrims.tooltip.properties.count.any_of", Styler::normal)
					.cycle(builder -> trimmedItems.stream()
							.flatMap(cycler -> cycler.getComponents().stream())
							.forEach(builder::component))
					.translate("bettertrims.tooltip.properties.count.equipped", Styler::normal)
					.spaced()
					.centred(true)
					.build();
			default -> CompositeContainerComponent.builder()
					.translate("bettertrims.tooltip.properties.count.n_of", Styler::normal, minCount)
					.stack(trimmedItems, 16)
					.translate("bettertrims.tooltip.properties.count.equipped", Styler::normal)
					.spaced()
					.centred(true)
					.build();
		};
	}
}