package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.version.VRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_2025;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3735;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7376;
import net.minecraft.class_7924;
import net.minecraft.class_9348;
import net.minecraft.class_9350;
import net.minecraft.class_9750;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

//? if >=1.21.8 {
/*import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.DataComponentMatchersTooltip;
import org.apache.commons.lang3.StringUtils;
*///?}

import static com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip.addMinMaxToBuilder;

public interface EntityPredicateTooltip {
	static void addToBuilder(class_638 level, class_2048 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_2050> entityTypePredicate = predicate.comp_1761();
		if (entityTypePredicate.isPresent()) {
			addEntityTypePredicateToBuilder(level, entityTypePredicate.orElseThrow(), state, builder);
		}

		Optional<class_2025> distancePredicate = predicate.comp_1762();
		if (distancePredicate.isPresent()) {
			addDistancePredicateToBuilder(level, distancePredicate.orElseThrow(), state, builder);
		}

		Optional<class_9750> movement = predicate.comp_2668();
		if (movement.isPresent()) {
			addMovementPredicateToBuilder(level, movement.orElseThrow(), state, builder);
		}

		class_2048.class_9777 location = predicate.comp_1763();
		Optional<class_2090> located = location.comp_2813();
		if (located.isPresent()) {
			addLocationPredicateToBuilder(level, located.orElseThrow(), state, builder);
		}

		Optional<class_2090> steppingOn = location.comp_2814();
		if (steppingOn.isPresent()) {
			addLocationPredicateToBuilder(level, steppingOn.orElseThrow(), state, builder);
		}

		Optional<class_2090> affectsMovement = location.comp_2815();
		if (affectsMovement.isPresent()) {
			addLocationPredicateToBuilder(level, affectsMovement.orElseThrow(), state, builder);
		}

		Optional<class_2102> effects = predicate.comp_1765();
		if (effects.isPresent()) {
			addMobEffectsPredicateToBuilder(level, effects.orElseThrow(), state, builder);
		}

		Optional<class_2105> nbt = predicate.comp_1766();
		if (nbt.isPresent()) {
			addNbtPredicateToBuilder(level, key("nbt"), nbt.orElseThrow(), state, builder);
		}

		Optional<class_2040> flags = predicate.comp_1767();
		if (flags.isPresent()) {
			addEntityFlagsPredicateToBuilder(level, flags.orElseThrow(), state, builder);
		}

		Optional<class_3735> equipment = predicate.comp_1768();
		if (equipment.isPresent()) {
			addEntityEquipmentPredicateToBuilder(level, equipment.orElseThrow(), state, builder);
		}

		Optional<class_7376> subPredicate = predicate.comp_1769();
		if (subPredicate.isPresent()) {
			addEntitySubPredicateToBuilder(level, subPredicate.orElseThrow(), state, builder);
		}

		Optional<Integer> periodicTick = predicate.comp_2669();
		if (periodicTick.isPresent()) {
			addPeriodicTickToBuilder(level, periodicTick.orElseThrow(), state, builder);
		}

		Optional<class_2048> vehicle = predicate.comp_1770();
		if (vehicle.isPresent()) {
			addEntityPredicateToBuilder(level, "vehicle", vehicle.orElseThrow(), state, builder);
		}

		Optional<class_2048> passenger = predicate.comp_1771();
		if (passenger.isPresent()) {
			addEntityPredicateToBuilder(level, "passenger", passenger.orElseThrow(), state, builder);
		}

		Optional<class_2048> targetedEntity = predicate.comp_1772();
		if (targetedEntity.isPresent()) {
			addEntityPredicateToBuilder(level, "targeted_entity", targetedEntity.orElseThrow(), state, builder);
		}

		Optional<String> team = predicate.comp_1773();
		if (team.isPresent()) {
			addTeamToBuilder(level, team.orElseThrow(), state, builder);
		}

		Optional<class_9350> slots = predicate.comp_2446();
		if (slots.isPresent()) {
			addSlotsPredicateToBuilder(level, slots.orElseThrow(), state, builder);
		}

		//? if >=1.21.8 {
		/*DataComponentMatchers components = predicate.components();
		if (!components.isEmpty()) {
			addDataComponentMatchersToBuilder(level, components, state, builder);
		}
		*///?}
	}

	static String key(String key) {
		return PredicateTooltip.key("entity.%s".formatted(key));
	}

	static void addEntityTypePredicateToBuilder(class_638 level, class_2050 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PredicateTooltip.addRegisteredElementsToBuilder(level, key("matches"), class_7924.field_41266, predicate.comp_1775(), class_1299::method_5897, state, builder);
	}

	static void addDistancePredicateToBuilder(class_638 level, class_2025 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2099 x = predicate.comp_1743();
		class_2096.class_2099 y = predicate.comp_1744();
		class_2096.class_2099 z = predicate.comp_1745();
		class_2096.class_2099 horizontal = predicate.comp_1746();
		class_2096.class_2099 absolute = predicate.comp_1747();

		CompositeContainerComponent.Builder distanceBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("distance"))
				.space();
		boolean useAnd = false;
		if (!x.method_9041()) {
			addMinMaxToBuilder(key("distance.x"), false, x, state, distanceBuilder);
			useAnd = true;
		}
		if (!y.method_9041()) {
			addMinMaxToBuilder(key("distance.y"), useAnd, y, state, distanceBuilder);
			useAnd = true;
		}
		if (!z.method_9041()) {
			addMinMaxToBuilder(key("distance.z"), useAnd, z, state, distanceBuilder);
			useAnd = true;
		}
		if (!horizontal.method_9041()) {
			addMinMaxToBuilder(key("distance.horizontal"), useAnd, horizontal, state, distanceBuilder);
			useAnd = true;
		}
		if (!absolute.method_9041()) {
			addMinMaxToBuilder(key("distance.absolute"), useAnd, absolute, state, distanceBuilder);
		}
		builder.component(distanceBuilder.build());
	}

	static void addMovementPredicateToBuilder(class_638 level, class_9750 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2099 x = predicate.comp_2772();
		class_2096.class_2099 y = predicate.comp_2773();
		class_2096.class_2099 z = predicate.comp_2774();
		class_2096.class_2099 horizontalSpeed = predicate.comp_2776();
		class_2096.class_2099 verticalSpeed = predicate.comp_2777();
		class_2096.class_2099 speed = predicate.comp_2775();
		class_2096.class_2099 fallDistance = predicate.comp_2778();

		CompositeContainerComponent.Builder movementBuilder = CompositeContainerComponent.builder();
		boolean useAnd = false;
		if (!x.method_9041()) {
			addMinMaxToBuilder(key("movement.x"), false, x, state, movementBuilder);
			useAnd = true;
		}
		if (!y.method_9041()) {
			addMinMaxToBuilder(key("movement.y"), useAnd, y, state, movementBuilder);
			useAnd = true;
		}
		if (!z.method_9041()) {
			addMinMaxToBuilder(key("movement.z"), useAnd, z, state, movementBuilder);
			useAnd = true;
		}
		if (!horizontalSpeed.method_9041()) {
			addMinMaxToBuilder(key("movement.horizontal_speed"), useAnd, horizontalSpeed, state, movementBuilder);
			useAnd = true;
		}
		if (!verticalSpeed.method_9041()) {
			addMinMaxToBuilder(key("movement.vertical_speed"), useAnd, verticalSpeed, state, movementBuilder);
			useAnd = true;
		}
		if (!speed.method_9041()) {
			addMinMaxToBuilder(key("movement.speed"), useAnd, speed, state, movementBuilder);
			useAnd = true;
		}
		if (!fallDistance.method_9041()) {
			addMinMaxToBuilder(key("movement.fall_distance"), useAnd, fallDistance, state, movementBuilder);
		}
		builder.component(movementBuilder.build());
	}

	static void addLocationPredicateToBuilder(class_638 level, class_2090 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		LocationPredicateTooltip.addToBuilder(level, predicate, state, builder);
	}

	static void addMobEffectsPredicateToBuilder(class_638 level, class_2102 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Map<class_6880<class_1291>, class_2102.class_2103> effectMap = predicate.comp_1811();
		if (effectMap.isEmpty()) {
			builder.space().translate(key("effects.any"), Styler::value);
		} else {
			class_2378<class_1291> registry = VRegistry.get(level, class_7924.field_41208);
			CompositeContainerComponent.Builder effectsBuilder = CompositeContainerComponent.builder()
					.space();
			if (effectMap.size() == 1) {
				effectsBuilder.translate(key("effects.single"), Styler::condition);
			} else {
				effectsBuilder.translate(key("effects.all_of"), Styler::condition);
			}
			effectsBuilder.space().cycle(effectCycler -> effectMap.forEach((effectHolder, effectInstancePredicate) -> {
				class_1291 effect = effectHolder.method_40229().map(registry::method_31140, Function.identity());

				CompositeContainerComponent.Builder effectBuilder = CompositeContainerComponent.builder()
						.translate(
								key("effects.effect"),
								Styler::condition,
								Styler.name(effect.method_5560().method_27661())
						);
				CompositeContainerComponent.Builder conditionBuilder = CompositeContainerComponent.builder();
				boolean useAnd = false;
				Optional<Boolean> ambient = effectInstancePredicate.comp_1814();
				if (ambient.isPresent()) {
					conditionBuilder.translate(key("effects.ambient.%s".formatted(ambient.orElseThrow() ? "true" : "false")), Styler::value);
					useAnd = true;
				}
				Optional<Boolean> visible = effectInstancePredicate.comp_1815();
				if (visible.isPresent()) {
					if (useAnd) conditionBuilder.literal(", ", Styler::condition);
					conditionBuilder.translate(key("effects.visible.%s".formatted(visible.orElseThrow() ? "true" : "false")), Styler::value);
					useAnd = true;
				}
				class_2096.class_2100 amplifier = effectInstancePredicate.comp_1812();
				if (!amplifier.method_9041()) {
					if (useAnd) conditionBuilder.literal(", ", Styler::condition);
					addMinMaxToBuilder(
							key("effects.amplifier"),
							false,
							amplifier,
							value -> class_2561.method_43471("enchantment.level.%s".formatted("%.0f".formatted(value + 1))),
							state, conditionBuilder
					);
					useAnd = true;
				}
				class_2096.class_2100 duration = effectInstancePredicate.comp_1813();
				if (!duration.method_9041()) {
					if (useAnd) conditionBuilder.literal(", ", Styler::condition);
					addMinMaxToBuilder(
							key("effects.duration"),
							false,
							duration,
							i -> Formatter.decimal(i * 20),
							state, conditionBuilder
					);
				}
				CompositeContainerComponent effectConditions = conditionBuilder.build();
				if (!effectConditions.isEmpty()) {
					effectBuilder.literal(" (", Styler::condition)
							.component(effectConditions)
							.literal(")", Styler::condition);
				}
				effectCycler.component(effectBuilder.build());
			}));
			builder.component(effectsBuilder.build());
		}
	}

	static void addNbtPredicateToBuilder(class_638 level, String key, class_2105 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		builder.component(CompositeContainerComponent.builder()
				.space()
				.translate(key, Styler::condition, Styler.value(class_2561.method_43470(predicate.comp_1816().toString())))
				.build());
	}

	static void addEntityFlagsPredicateToBuilder(class_638 level, class_2040 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Map<String, Optional<Boolean>> flagMap = Map.of(
				"on_ground", predicate.comp_2666(),
				"on_fire", predicate.comp_1756(),
				"crouching", predicate.comp_1757(),
				"sprinting", predicate.comp_1758(),
				"swimming", predicate.comp_1759(),
				"flying", predicate.comp_2667(),
				"baby", predicate.comp_1760()
		);
		CompositeContainerComponent.Builder flagsBuilder = CompositeContainerComponent.builder().space();
		boolean useAnd = false;
		for (Map.Entry<String, Optional<Boolean>> entry : flagMap.entrySet()) {
			if (entry.getValue().isPresent()) {
				if (useAnd) {
					flagsBuilder.literal(" & ", Styler::condition);
				}
				flagsBuilder.translate(key("flags.%s.%s".formatted(entry.getKey(), entry.getValue().orElseThrow() ? "true" : "false")), Styler::value);
				useAnd = true;
			}
		}
	}

	static void addEntityEquipmentPredicateToBuilder(class_638 level, class_3735 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Map<class_1304, Optional<class_2073>> equipmentMap = Map.of(
				class_1304.field_6169, predicate.comp_1750(),
				class_1304.field_6174, predicate.comp_1751(),
				class_1304.field_6172, predicate.comp_1752(),
				class_1304.field_6166, predicate.comp_1753(),
				class_1304.field_6173, predicate.comp_1754(),
				class_1304.field_6171, predicate.comp_1755()
		);
		List<CompositeContainerComponent> equipmentComponents = equipmentMap.entrySet()
				.stream()
				.map((entry) -> {
					class_1304 slot = entry.getKey();
					Optional<class_2073> itemPredicate = entry.getValue();
					if (itemPredicate.isEmpty()) return null;

					CompositeContainerComponent.Builder itemBuilder = CompositeContainerComponent.builder()
							.translate(key("equipment.item"), Styler::condition);
					ItemPredicateTooltip.addToBuilder(level, itemPredicate.orElseThrow(), new LootConditionTooltips.State().withUseWith(true), itemBuilder);
					class_2561 slotName = Styler.name(class_2561.method_43470(StringUtils.capitalize(slot.method_5923())));
					itemBuilder.space().translate(key("equipment.slot"), Styler::condition, slotName);
					return itemBuilder.build();
				})
				.filter(Objects::nonNull)
				.toList();
		CompositeContainerComponent.Builder equipmentComponentBuilder = CompositeContainerComponent.builder();
		if (equipmentComponents.size() == 1) {
			equipmentComponentBuilder.translate(key("equipment.single"), Styler::condition);
			equipmentComponentBuilder.space().component(equipmentComponents.getFirst());
		} else if (equipmentComponents.size() > 1) {
			equipmentComponentBuilder.vertical().translate(key("equipment.all_of"), Styler::condition);
			CompositeContainerComponent.Builder entryBuilder = CompositeContainerComponent.builder().vertical();
			equipmentComponents.forEach((entry) -> entryBuilder.component(
					CompositeContainerComponent.builder()
							.literal("• ", Styler::condition)
							.component(entry)
							.build())
			);
			equipmentComponentBuilder.component(entryBuilder.build());
		}
		CompositeContainerComponent.Builder equipmentBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("equipment.matches"), Styler::condition)
				.space()
				.component(equipmentComponentBuilder.build());
		builder.component(equipmentBuilder.build());
	}

	static void addEntitySubPredicateToBuilder(class_638 level, class_7376 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		EntitySubPredicateTooltip.addToBuilder(level, predicate, state, builder);
	}

	static void addPeriodicTickToBuilder(class_638 level, int tick, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		builder.component(CompositeContainerComponent.builder()
				.space()
				.translate(key("periodic_tick"), Styler.number(tick))
				.build());
	}

	static void addEntityPredicateToBuilder(class_638 level, String label, class_2048 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		CompositeContainerComponent.Builder entityBuilder = CompositeContainerComponent.builder()
				.translate(key("%s.matches".formatted(label)), Styler::condition)
				.space();
		EntityPredicateTooltip.addToBuilder(level, predicate, state, entityBuilder);
		builder.component(entityBuilder.build());
	}

	static void addTeamToBuilder(class_638 level, String team, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		builder.component(CompositeContainerComponent.builder()
				.space()
				.translate(key("team"), Styler.name(class_2561.method_43470(team)))
				.build());
	}

	static void addSlotsPredicateToBuilder(class_638 level, class_9350 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Map<class_9348, class_2073> slots = predicate.comp_2455();
		CompositeContainerComponent.Builder slotsBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("slots.matches"), Styler::condition)
				.space()
				.cycle(slotCycler -> slots.forEach((slotRange, itemPredicate) -> {
					IntList slotsList = slotRange.method_58075();
					if (slotsList.isEmpty()) return;

					for (int i = 0; i < slotsList.size(); i++) {
						int slot = slotsList.getInt(i);
						CompositeContainerComponent.Builder slotBuilder = CompositeContainerComponent.builder()
								.translate(key("slots.slot"), Styler::condition, Styler.number(slot))
								.space();
						ItemPredicateTooltip.addToBuilder(level, itemPredicate, new LootConditionTooltips.State(), slotBuilder);
						slotCycler.component(slotBuilder.build());
					}
				}));
		builder.component(slotsBuilder.build());
	}

	//? if >=1.21.8 {
	/*static void addDataComponentMatchersToBuilder(ClientLevel level, DataComponentMatchers components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		DataComponentMatchersTooltip.addToBuilder(level, components, state, builder);
	}
	*///?}
}
