package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_4553;
import net.minecraft.class_4965;
import net.minecraft.class_638;
import net.minecraft.class_6404;
import net.minecraft.class_7376;
import net.minecraft.class_7383;
import net.minecraft.class_9471;
import java.util.Optional;

public interface EntitySubPredicateTooltip {
	static void addToBuilder(class_638 level, class_7376 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		switch (predicate) {
			case FishingHookPredicate fishingHookPredicate ->
					addFishingHookPredicateToBuilder(level, fishingHookPredicate, state, builder);
			case LightningBoltPredicate lightningBoltPredicate ->
					addLightningBoltPredicateToBuilder(level, lightningBoltPredicate, state, builder);
			case PlayerPredicate playerPredicate -> addPlayerPredicateToBuilder(level, playerPredicate, state, builder);
			case SlimePredicate slimePredicate -> addSlimePredicateToBuilder(level, slimePredicate, state, builder);
			case RaiderPredicate raiderPredicate -> addRaiderPredicateToBuilder(level, raiderPredicate, state, builder);
			//? if >=1.21.8 {
			/*case SheepPredicate sheepPredicate -> addSheepPredicateToBuilder(level, sheepPredicate, state, builder);
			 *///?}
			default -> builder.translate(key("unknown"), Styler::negative);
		}
	}

	static String key(String key) {
		return PredicateTooltip.key("sub_entity.%s".formatted(key));
	}

	static void addFishingHookPredicateToBuilder(class_638 level, class_4965 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<Boolean> inOpenWater = predicate.comp_1779();
		if (inOpenWater.isPresent()) {
			builder.component(CompositeContainerComponent.builder()
					.translate(key("fishing_hook.in_open_water.%s".formatted(inOpenWater.orElse(false) ? "true" : "false")), Styler::value)
					.build());
		}
	}

	static void addLightningBoltPredicateToBuilder(class_638 level, class_6404 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		CompositeContainerComponent.Builder boltBuilder = CompositeContainerComponent.builder();

		boolean useAnd = false;
		Optional<class_2048> struck = predicate.comp_1793();
		if (struck.isPresent()) {
			CompositeContainerComponent.Builder entityBuilder = CompositeContainerComponent.builder();
			EntityPredicateTooltip.addToBuilder(level, struck.orElseThrow(), state, entityBuilder);
			boltBuilder.component(CompositeContainerComponent.builder()
					.space()
					.translate(key("lightning_bolt.entity_struck"), Styler::condition)
					.space()
					.component(entityBuilder.build())
					.build());
			useAnd = true;
		}

		class_2096.class_2100 blocksSetOnFire = predicate.comp_1792();
		if (!blocksSetOnFire.method_9041()) {
			PredicateTooltip.addMinMaxToBuilder(key("lightning_bolt.blocks_set_on_fire"), useAnd, blocksSetOnFire, state, boltBuilder);
		}
		CompositeContainerComponent boltComponent = boltBuilder.build();
		if (!boltComponent.isEmpty()) {
			builder.component(CompositeContainerComponent.builder()
					.space()
					.translate(key("lightning_bolt.matches"), Styler::condition)
					.space()
					.component(boltComponent)
					.build());
		}
	}

	static void addPlayerPredicateToBuilder(class_638 level, class_4553 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PlayerPredicateTooltip.addToBuilder(level, predicate, state, builder);
	}

	//? if >=1.21.8 {
    /*static void addSheepPredicateToBuilder(ClientLevel level, SheepPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional<Boolean> sheared = predicate.sheared();
        if (sheared.isPresent()) {
            builder.component(CompositeContainerComponent.builder()
                .space()
                .translate(key("sheep.sheared.%s".formatted(sheared.orElse(false) ? "true" : "false")), Styler::value)
                .build());
        }
    }
    *///?}

	static void addSlimePredicateToBuilder(class_638 level, class_7383 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2100 size = predicate.comp_1829();
		if (!size.method_9041()) {
			CompositeContainerComponent.Builder sizeBuilder = CompositeContainerComponent.builder().space();
			PredicateTooltip.addMinMaxToBuilder(key("slime.size"), false, size, state, sizeBuilder);
			builder.component(sizeBuilder.build());
		}
	}

	static void addRaiderPredicateToBuilder(class_638 level, class_9471 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		boolean hasRaid = predicate.comp_2549();
		boolean captain = predicate.comp_2550();
		if (hasRaid || captain) {
			String key = "raider.";
			if (hasRaid) key += "in_raid";
			if (captain) {
				if (hasRaid) key += "_and_";
				key += "is_captain";
			}
			builder.component(CompositeContainerComponent.builder()
					.space()
					.translate(key(key), Styler::value)
					.build());
		}
	}
}
