package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.ExactDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.PartialDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9329;
import net.minecraft.class_9331;
import net.minecraft.class_9360;

import static com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip.addMinMaxToBuilder;

public interface ItemPredicateTooltip {
	static void addToBuilder(class_638 level, class_2073 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_6885<class_1792>> items = predicate.comp_1784();
		if (items.isPresent()) {
			addItemsToBuilder(level, items.orElseThrow(), state, builder);
			state = state.withUseWith(true);
		}

		//? if >=1.21.8 {
        /*DataComponentMatchers components = predicate.components();
        if (!components.isEmpty()) {
            addDataComponentMatchersToBuilder(level, components, state, builder);
        }
        *///?} else {
		class_9329 components = predicate.comp_2374();
		if (!components.method_57870().method_57848()) {
			addDataComponentMatchersToBuilder(level, components, state, builder);
		}

		Map<class_9360.class_8745<?>, class_9360> subPredicates = predicate.comp_2462();
		if (!subPredicates.isEmpty()) {
			addSubPredicatesToBuilder(level, subPredicates, state, builder);
		}
		//?}

		class_2096.class_2100 count = predicate.comp_1785();
		if (!count.method_9041()) {
			addCountToBuilder(level, count, state, builder);
		}
	}


	static String key(String key) {
		return PredicateTooltip.key("item.%s".formatted(key));
	}

	static void addItemsToBuilder(class_638 level, class_6885<class_1792> items, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PredicateTooltip.addRegisteredElementsToBuilder(
				level,
				key("matches"),
				class_7924.field_41197,
				items,
				//? if >=1.21.8 {
				/*item -> item.getName(),
				 *///?} else {
				item -> item.method_7864(item.method_7854()),
				//?}
				state,
				builder
		);
	}

	//? if >=1.21.8 {
    /*static void addDataComponentMatchersToBuilder(ClientLevel level, DataComponentMatchers components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (state.doPrefixSpace()) {
            builder.space();
        }
        builder.translate("bettertrims.tooltip.condition.match_tool.has.%s".formatted(state.key()), Styler::condition);
        DataComponentMatchersTooltip.addToBuilder(level, components, state, builder);
    }
    *///?} else {
	static void addDataComponentMatchersToBuilder(class_638 level, class_9329 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (state.doPrefixSpace()) {
			builder.space();
		}
		builder.translate(key("data"), Styler::condition);

		Set<Map.Entry<class_9331<?>, Optional<?>>> entries = predicate.method_57870().method_57846();
		if (entries.isEmpty()) {
			builder.translate(key("data.exact.any"), Styler::condition);
		} else if (entries.size() == 1) {
			Map.Entry<class_9331<?>, Optional<?>> entry = entries.iterator().next();
			Optional<?> value = entry.getValue();
			if (value.isEmpty()) {
				class_2960 key = class_7923.field_49658.method_10221(entry.getKey());
				if (key != null) {
					builder.translate(key("data.exact.any_for_type"), Styler::condition, Styler.property(class_2561.method_43470(key.toString())));
				} else {
					builder.translate(key("data.unknown"), Styler::condition);
				}
				return;
			}

			ExactDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue().orElseThrow(), state, builder);
		} else {
			CompositeContainerComponent.Builder listBuilder = CompositeContainerComponent.builder()
					.vertical()
					.literal(":", Styler::condition);
			for (Map.Entry<class_9331<?>, Optional<?>> entry : entries) {
				Optional<?> value = entry.getValue();
				CompositeContainerComponent.Builder termBuilder = CompositeContainerComponent.builder()
						.space()
						.literal("• ", Styler::condition);
				if (value.isEmpty()) {
					class_2960 key = class_7923.field_49658.method_10221(entry.getKey());
					if (key != null) {
						termBuilder.translate(key("data.exact.any_for_type"), Styler::condition, Styler.property(class_2561.method_43470(key.toString())));
					} else {
						termBuilder.translate(key("data.unknown"), Styler::condition);
					}
				} else {
					ExactDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue().orElse(null), state, termBuilder);
				}
				listBuilder.component(termBuilder.build());
			}
			builder.component(listBuilder.build());
		}
	}

	static void addSubPredicatesToBuilder(class_638 level, Map<class_9360.class_8745<?>, class_9360> subPredicates, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (state.doPrefixSpace()) {
			builder.space();
		}
		builder.translate(key("data.partial"), Styler::condition);

		if (subPredicates.isEmpty()) {
			builder.translate(key("data.unknown"));
		} else if (subPredicates.size() == 1) {
			Map.Entry<class_9360.class_8745<?>, class_9360> entry = subPredicates.entrySet().iterator().next();
			PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
		} else {
			CompositeContainerComponent.Builder listBuilder = CompositeContainerComponent.builder()
					.vertical()
					.literal(":", Styler::condition);
			for (Map.Entry<class_9360.class_8745<?>, class_9360> entry : subPredicates.entrySet()) {
				CompositeContainerComponent.Builder termBuilder = CompositeContainerComponent.builder()
						.space()
						.literal("• ", Styler::condition);
				PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
				listBuilder.component(termBuilder.build());
			}
			builder.component(listBuilder.build());
		}
	}
	//?}

	static void addCountToBuilder(class_638 level, class_2096.class_2100 count, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		CompositeContainerComponent.Builder countBuilder = CompositeContainerComponent.builder().space();
		addMinMaxToBuilder(key("count"), false, count, state, countBuilder);
		builder.component(countBuilder.build());
	}
}
