package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact.*;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public final class ExactDataComponentPredicateTooltipAdders {
	private static final Map<class_9331<?>, ExactAdder<?>> EXACT_ADDERS = new HashMap<>();

	static {
		register(class_9334.field_49628, new CustomDataExactAdder("custom"));
		register(class_9334.field_50071, ExactAdder.simple((maxStackSize, builder) ->
				builder.translate(key("max_stack_size"), Styler::condition, Styler.number(maxStackSize))
		));
		register(class_9334.field_50072, ExactAdder.simple((maxDamage, builder) ->
				builder.translate(key("max_damage"), Styler::condition, Styler.number(maxDamage))
		));
		register(class_9334.field_49629, ExactAdder.simple((damage, builder) ->
				builder.translate(key("damage"), Styler::condition, Styler.number(damage))
		));
		register(class_9334.field_49630, ExactAdder.simple((unit, builder) ->
				builder.translate(key("unbreakable"), Styler::condition)
		));
		register(class_9334.field_49631, ExactAdder.simple((name, builder) ->
				builder.translate(key("custom_name"), Styler::condition, Styler.value(name.method_27661()))
		));
		register(class_9334.field_50239, ExactAdder.simple((name, builder) ->
				builder.translate(key("item_name"), Styler::condition, Styler.value(name.method_27661()))
		));
		register(class_9334.field_49632, new ItemLoreExactAdder());
		register(class_9334.field_50073, ExactAdder.simple((rarity, builder) ->
				builder.translate(key("rarity"), Styler::condition, class_2561.method_43470(rarity.name()).method_27692(rarity.method_58413()))
		));
		register(class_9334.field_49633, new EnchantmentsExactAdder("enchantments"));
		register(class_9334.field_49634, new AdventureModePredicateExactAdder("can_place_on"));
		register(class_9334.field_49635, new AdventureModePredicateExactAdder("can_break"));
		register(class_9334.field_49636, new ItemAttributeModifiersExactAdder());
		register(class_9334.field_49637, new CustomModelDataExactAdder());
		register(class_9334.field_49639, ExactAdder.simple((repairCost, builder) ->
				builder.translate(key("repair_cost"), Styler::condition, Styler.number(class_2561.method_43470(repairCost.toString())))
		));
		register(class_9334.field_49640, ExactAdder.simple((unit, builder) ->
				builder.translate(key("creative_slot_lock"), Styler::condition)
		));
		register(class_9334.field_49641, ExactAdder.simple((glint, builder) ->
				builder.translate(key("enchantment_glint_override.%s".formatted(glint.toString())), Styler::condition)
		));
		register(class_9334.field_49642, ExactAdder.simple((unit, builder) ->
				builder.translate(key("intangible_projectile"), Styler::condition)
		));
		register(class_9334.field_50075, new FoodPropertiesExactAdder());
		register(class_9334.field_50077, new ToolExactAdder());
		register(class_9334.field_49643, new EnchantmentsExactAdder("stored_enchantments"));
		register(class_9334.field_49644, new DyedItemColorExactAdder());
		register(class_9334.field_49645, new MapItemColorExactAdder());
		register(class_9334.field_49646, ExactAdder.simple((mapId, builder) ->
				builder.translate(key("map_id"), Styler::condition, Styler.number(mapId.comp_2315()))
		));
		register(class_9334.field_49647, new MapDecorationsExactAdder());
		register(class_9334.field_49648, ExactAdder.ofEnum("map_post_processing"));
		register(class_9334.field_49649, new ChargedProjectilesExactAdder());
		register(class_9334.field_49650, new BundleContentsExactAdder());
		register(class_9334.field_49651, new PotionContentsExactAdder());
		register(class_9334.field_49652, new SuspiciousStewEffectsExactAdder());
		register(class_9334.field_49653, new WritableBookContentExactAdder());
		register(class_9334.field_49606, new WrittenBookContentExactAdder());
		register(class_9334.field_49607, new ArmorTrimExactAdder());
		register(class_9334.field_49608, new DebugStickStateExactAdder());
		register(class_9334.field_49609, new CustomDataExactAdder("entity"));
		register(class_9334.field_49610, new CustomDataExactAdder("bucket_entity"));
		register(class_9334.field_49611, new CustomDataExactAdder("block_entity"));
		register(class_9334.field_52175, new JukeboxPlayableExactAdder());
		register(class_9334.field_49614, new LodestoneTrackerExactAdder());
		register(class_9334.field_49615, new FireworkExplosionExactAdder());
		register(class_9334.field_49616, new FireworksExactAdder());
		register(class_9334.field_49617, new ResolvableProfileExactAdder());
		register(class_9334.field_49618, ExactAdder.simple((sound, builder) ->
				builder.translate(key("note_block_sound"), Styler::condition, Styler.name(class_2561.method_43470(sound.toString())))
		));
		register(class_9334.field_49619, new BannerPatternLayersExactAdder());
		register(class_9334.field_49620, ExactAdder.ofEnum("base_color"));
		register(class_9334.field_49621, new PotDecorationsExactAdder());
		register(class_9334.field_49622, new ItemContainerContentsExactAdder());
		register(class_9334.field_49623, new BlockItemStatePropertiesExactAdder());
		register(class_9334.field_49626, new SeededContainerLootExactAdder());
		//? if <1.21.8 {
		register(class_9334.field_49625, ExactAdder.simple((lock, builder) ->
				builder.translate(key("lock"), Styler::condition, Styler.value(class_2561.method_43470(lock.comp_2371())))
		));
		register(class_9334.field_50238, ExactAdder.simple((amplifier, builder) ->
				builder.translate(key("ominous_bottle_amplifier"), Styler::condition, Styler.number(amplifier))
		));
		register(class_9334.field_49612, new InstrumentHolderExactAdder());
		register(class_9334.field_49613, new IdListExactAdder());
		register(class_9334.field_49624, new BeehiveBlockEntityOccupantListExactAdder());
		register(class_9334.field_50076, ExactAdder.simple((unit, builder) ->
				builder.translate(key("fire_resistant"), Styler::condition)
		));
		//?} else {
		/*register(DataComponents.ITEM_MODEL, ExactAdder.simple((itemModel, builder) ->
				builder.translate(key("item_model"), Styler::condition, Styler.value(Component.literal(itemModel.toString())))
		));
		register(DataComponents.TOOLTIP_DISPLAY, new TooltipDisplayExactAdder());
		register(DataComponents.CONSUMABLE, new ConsumableExactAdder());
		register(DataComponents.USE_REMAINDER, new UseRemainderExactAdder());
		register(DataComponents.USE_COOLDOWN, new UseCooldownExactAdder());
		register(DataComponents.DAMAGE_RESISTANT, new DamageResistantExactAdder());
		register(DataComponents.WEAPON, new WeaponExactAdder());
		register(DataComponents.ENCHANTABLE, ExactAdder.simple((enchantable, builder) ->
				builder.translate(key("enchantable"), Styler::condition, Styler.number(enchantable.value()))
		));
		register(DataComponents.EQUIPPABLE, new EquippableExactAdder());
		register(DataComponents.REPAIRABLE, new RepairableExactAdder());
		register(DataComponents.GLIDER, ExactAdder.simple((unit, builder) ->
				builder.translate(key("glider"), Styler::condition)
		));
		register(DataComponents.TOOLTIP_STYLE, ExactAdder.simple((tooltipStyle, builder) ->
				builder.translate(key("tooltip_style"), Styler::condition, Styler.value(Component.literal(tooltipStyle.toString()))
				)));
		register(DataComponents.DEATH_PROTECTION, new DeathProtectionExactAdder());
		register(DataComponents.BLOCKS_ATTACKS, new BlocksAttacksExactAdder());
		register(DataComponents.POTION_DURATION_SCALE, ExactAdder.simple((durationScale, builder) ->
				builder.translate(key("potion_duration_scale"), Styler::condition, Styler.number(durationScale))
		));
		register(DataComponents.PROVIDES_TRIM_MATERIAL, new ProvidesTrimMaterialExactAdder());
		register(DataComponents.LOCK, new LockCodeExactAdder());
		register(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, ExactAdder.simple((amplifier, builder) ->
				builder.translate(key("ominous_bottle_amplifier"), Styler::condition, Styler.number(amplifier.value()))
		));
		register(DataComponents.INSTRUMENT, new InstrumentComponentExactAdder());
		register(DataComponents.RECIPES, new RecipeResourceKeyListExactAdder());
		register(DataComponents.BEES, new BeesExactAdder());
		register(DataComponents.BREAK_SOUND, new SoundEventHolderExactAdder());
		register(DataComponents.VILLAGER_VARIANT, new VillagerTypeHolderExactAdder());
		register(DataComponents.WOLF_VARIANT, new WolfVariantHolderExactAdder());
		register(DataComponents.WOLF_SOUND_VARIANT, new WolfSoundVariantHolderExactAdder());
		register(DataComponents.WOLF_COLLAR, ExactAdder.ofEnum("wolf_collar"));
		register(DataComponents.FOX_VARIANT, ExactAdder.ofEnum("fox_variant"));
		register(DataComponents.SALMON_SIZE, ExactAdder.ofEnum("salmon_size"));
		register(DataComponents.PARROT_VARIANT, ExactAdder.ofEnum("parrot_variant"));
		register(DataComponents.TROPICAL_FISH_PATTERN, ExactAdder.ofEnum("tropical_fish_pattern"));
		register(DataComponents.TROPICAL_FISH_BASE_COLOR, ExactAdder.ofEnum("tropical_fish_base_color"));
		register(DataComponents.TROPICAL_FISH_PATTERN_COLOR, ExactAdder.ofEnum("tropical_fish_pattern_color"));
		register(DataComponents.MOOSHROOM_VARIANT, ExactAdder.ofEnum("mooshroom_variant"));
		register(DataComponents.RABBIT_VARIANT, ExactAdder.ofEnum("rabbit_variant"));
		register(DataComponents.PIG_VARIANT, new PigVariantHolderExactAdder());
		register(DataComponents.COW_VARIANT, new CowVariantHolderExactAdder());
		register(DataComponents.CHICKEN_VARIANT, new ChickenVariantEitherHolderExactAdder());
		register(DataComponents.FROG_VARIANT, new FrogVariantHolderExactAdder());
		register(DataComponents.HORSE_VARIANT, ExactAdder.ofEnum("horse_variant"));
		register(DataComponents.PAINTING_VARIANT, new PaintingVariantHolderExactAdder());
		register(DataComponents.LLAMA_VARIANT, ExactAdder.ofEnum("llama_variant"));
		register(DataComponents.AXOLOTL_VARIANT, ExactAdder.ofEnum("axolotl_variant"));
		register(DataComponents.CAT_VARIANT, new CatVariantHolderExactAdder());
		register(DataComponents.CAT_COLLAR, ExactAdder.ofEnum("cat_collar"));
		register(DataComponents.SHEEP_COLOR, ExactAdder.ofEnum("sheep_color"));
		register(DataComponents.SHULKER_COLOR, ExactAdder.ofEnum("shulker_color"));
		*///?}
	}
	
	private static <T> void register(class_9331<T> type, ExactAdder<T> adder) {
		if(EXACT_ADDERS.containsKey(type)) {
			throw new IllegalStateException("Duplicate data component type: " + type);
		}
		EXACT_ADDERS.put(type, adder);
	}

	@SuppressWarnings("unchecked")
	public static void addToBuilder(class_638 level, class_9331<?> type, Object object, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		ExactAdder<Object> adder = (ExactAdder<Object>) EXACT_ADDERS.getOrDefault(type, ExactAdder.UNKNOWN.apply(type));
		adder.addToBuilder(level, object, state, builder);
	}

	public static String key(String key) {
		return PredicateTooltip.key("data.exact.%s".formatted(key));
	}
}
