package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.PartialDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_2096;
import net.minecraft.class_638;
import net.minecraft.class_9360;
import net.minecraft.class_9639;
import net.minecraft.class_9643;
import net.minecraft.class_9648;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface PartialAdder<T extends /*$ item_data_predicate >>*/ class_9360 > {
	Function</*$ item_data_predicate >>*/ class_9360 .class_8745<?>, PartialAdder<? extends /*$ item_data_predicate >>*/ class_9360 >> UNKNOWN = type -> (level, predicate, state, builder) -> builder.translate(
			PartialDataComponentPredicateTooltipAdders.key("unknown_type"),
			Styler::property,
			type.toString()
	);

	void addToBuilder(class_638 level, T predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder);

	default String key(String key) {
		return PartialDataComponentPredicateTooltipAdders.key(key);
	}

	default <C, P extends Predicate<C>> void addCollectionToBuilder(class_638 level, class_9648<C, P> collection, String key, PredicateAdder<P> contentAdder, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_9639<C, P>> contains = collection.comp_2617();
		Optional<class_9643<C, P>> counts = collection.comp_2618();
		Optional<class_2096.class_2100> size = collection.comp_2619();
		if ((contains.isEmpty() || contains.orElseThrow().method_59605().isEmpty())
				&& (counts.isEmpty() || counts.orElseThrow().method_59613().isEmpty())
				&& (size.isEmpty() || size.orElseThrow().method_9041())) {
			builder.space().translate(key(key + ".any"), Styler::condition);
			return;
		}

		builder.cycle(cycleBuilder -> {
			if (contains.isPresent()) {
				class_9639<C, P> collectionContentsPredicate = contains.get();
				List<P> contentPredicates = collectionContentsPredicate.method_59605();
				BiConsumer<CompositeContainerComponent.Builder, P> contentHeader = (contentPredicateBuilder, contentPredicate) -> {
					contentAdder.addToBuilder(level, contentPredicate, state, contentPredicateBuilder);
					cycleBuilder.component(contentPredicateBuilder.build());
				};
				if (contentPredicates.size() == 1) {
					contentHeader.accept(
							CompositeContainerComponent.builder()
									.space()
									.translate(key(key + ".single"), Styler::condition)
									.space(),
							contentPredicates.getFirst()
					);
				} else {
					for (P contentPredicate : contentPredicates) {
						contentHeader.accept(
								CompositeContainerComponent.builder()
										.space()
										.translate(key(key + ".all_of"), Styler::condition)
										.space(),
								contentPredicate
						);
					}
				}
			}

			if (counts.isPresent()) {
				class_9643<C, P> collectionCountsPredicate = counts.get();
				List<class_9643.class_9644<C, P>> countPredicates = collectionCountsPredicate.method_59613();
				BiConsumer<CompositeContainerComponent.Builder, class_9643.class_9644<C, P>> countHeader = (contentPredicateBuilder, countPredicateEntry) -> {
					class_2096.class_2100 count = countPredicateEntry.comp_2614();
					P countPredicate = countPredicateEntry.comp_2613();
					contentAdder.addToBuilder(level, countPredicate, state, contentPredicateBuilder);
					contentPredicateBuilder.literal("\"", Styler::condition).space();
					PredicateTooltip.addMinMaxToBuilder(
							key(key + ".count"),
							false,
							count,
							state.withPrefixSpace(false),
							contentPredicateBuilder
					);
					state.withPrefixSpace(true);
					cycleBuilder.component(contentPredicateBuilder.build());
				};
				if (countPredicates.size() == 1) {
					countHeader.accept(
							CompositeContainerComponent.builder()
									.space()
									.translate(key(key + ".single"), Styler::condition)
									.space()
									.literal("\"", Styler::condition),
							countPredicates.getFirst()
					);
				} else {
					for (class_9643.class_9644<C, P> countPredicateEntry : countPredicates) {
						countHeader.accept(
								CompositeContainerComponent.builder()
										.space()
										.translate(key(key + ".all_of"), Styler::condition)
										.space()
										.literal("\"", Styler::condition),
								countPredicateEntry
						);
					}
				}
			}

			if (size.isPresent()) {
				class_2096.class_2100 sizeBounds = size.orElseThrow();
				CompositeContainerComponent.Builder itemPredicateBuilder = CompositeContainerComponent.builder();
				itemPredicateBuilder.space()
						.translate(key(key + ".size"), Styler::condition);
				PredicateTooltip.addMinMaxToBuilder(
						key(key + ".size"),
						false,
						sizeBounds,
						state,
						itemPredicateBuilder
				);
				cycleBuilder.component(itemPredicateBuilder.build());
			}
		});
	}
}