package com.bawnorton.bettertrims.mixin.property.ability.damage;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1890.class)
abstract class EnchantmentHelperMixin {
	@ModifyReturnValue(
			method = "modifyDamage",
			at = @At("RETURN")
	)
	private static float applyTrimToDamage(float original, class_3218 level, class_1799 tool, class_1297 entity, class_1282 source) {
		if (!(source.method_5529() instanceof class_1309 wearer)) return original;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (TrimValueAbilityRunner<?> ability : property.getValueAbilityRunners(TrimAbilityComponents.DAMAGE)) {
				original = ability.runDamage(level, wearer, source, original);
			}
		}
		return original;
	}
}
