package com.bawnorton.bettertrims.mixin.property.ability.damage_immunity;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1890.class)
abstract class EnchantmentHelperMixin {
	@ModifyReturnValue(
			method = "isImmuneToDamage",
			at = @At("RETURN")
	)
	private static boolean isTrimInvulnerableTo(boolean original, class_3218 level, class_1309 entity, class_1282 damageSource) {
		if (original) return true;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (ElementMatcher<?> ability : property.getAbilityElements(TrimAbilityComponents.DAMAGE_IMMUNITY)) {
				return ability.matches(entity, TrimContexts.damage(level, ability.getMatchingItems(entity), entity, damageSource));
			}
		}
		return false;
	}
}
