package com.bawnorton.bettertrims.networking;

import com.bawnorton.bettertrims.mixin.accessor.SmithingTrimRecipeAccessor;
import com.bawnorton.bettertrims.networking.packet.TrimPatternSourcePayload;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_8056;
import net.minecraft.class_8057;
import net.minecraft.class_8062;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import java.util.*;

//? if fabric {
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
//?} else {
/*import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber
*///?}
public class Networking {
	private static final Map<class_6880<class_8056>, class_6885<class_1792>> patternProviders = new HashMap<>();

	//? if fabric {
	public static void init() {
		PayloadTypeRegistry.playS2C().register(TrimPatternSourcePayload.TYPE, TrimPatternSourcePayload.CODEC);

		ServerPlayConnectionEvents.JOIN.register((handler, sender, server) ->
				send(handler.field_14140, new TrimPatternSourcePayload(patternProviders))
		);

		ServerLifecycleEvents.SERVER_STARTED.register(Networking::updatePatternProviders);
	}

	public static <T extends class_8710> void send(class_3222 player, T payload) {
		ServerPlayNetworking.send(player, payload);
	}
	//?} else {
	/*public static void init() {}

	@SubscribeEvent
	public static void registerPackets(RegisterPayloadHandlersEvent event) {
		PayloadRegistrar registrar = event.registrar("1");
		registrar.playToClient(TrimPatternSourcePayload.TYPE, TrimPatternSourcePayload.CODEC, TrimPatternSourcePayload::handle);
	}

	@SubscribeEvent
	public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
		if(!(event.getEntity() instanceof ServerPlayer player)) return;

		send(player, new TrimPatternSourcePayload(patternProviders));
	}

	@SubscribeEvent
	public static void onServerStart(ServerStartedEvent event) {
		updatePatternProviders(event.getServer());
	}

	public static <T extends CustomPacketPayload> void send(ServerPlayer player, T payload) {
		PacketDistributor.sendToPlayer(player, payload);
	}
	*///?}

	private static void updatePatternProviders(MinecraftServer server) {
		class_1863 recipeManager = server.method_3772();
		patternProviders.clear();
		for (class_8786<?> holder : recipeManager.method_8126()) {
			if (holder.comp_1933() instanceof class_8062 recipe) {
				List<class_6880<class_1792>> patternItems = new ArrayList<>();
				//? if >=1.21.8 {
				/*recipe.templateIngredient().ifPresent(ingredient -> ingredient.items().forEach(patternItems::add));
				Holder<TrimPattern> patternHolder = ((SmithingTrimRecipeAccessor) recipe).bettertrims$pattern();
				*///?} else {
				SmithingTrimRecipeAccessor accessor = (SmithingTrimRecipeAccessor) recipe;
				class_1856 templateIngredient = accessor.bettertrims$template();
				List<class_1799> templateItems = Arrays.asList(templateIngredient.method_8105());
				List<class_6880.class_6883<class_8056>> patternHolders = templateItems.stream().map(stack -> class_8057.method_48448(server.method_30611(), stack))
						.flatMap(Optional::stream)
						.toList();
				class_6880<class_8056> patternHolder = patternHolders.getFirst();
				if (patternHolder == null) continue;

				templateItems.forEach(stack -> {
					class_1792 item = stack.method_7909();
					patternItems.add(class_6880.method_40223(item));
				});
				//?}
				patternProviders.put(patternHolder, class_6885.method_40242(patternItems));
			}
		}
	}
}