package com.bawnorton.bettertrims.property;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

public record Matcher(class_6885<class_8054> material, class_6885<class_8056> pattern, int minCount) {
	public static final Codec<Matcher> CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_6898.method_40388(class_7924.field_42083, class_8054.field_42003, false)
					.optionalFieldOf("material", class_6885.method_58563())
					.forGetter(Matcher::material),
			class_6898.method_40388(class_7924.field_42082, class_8056.field_42015, false)
					.optionalFieldOf("pattern", class_6885.method_58563())
					.forGetter(Matcher::pattern),
			class_5699.method_48766(1, 255)
					.optionalFieldOf("min_count", 1)
					.forGetter(Matcher::minCount)
	).apply(instance, Matcher::new));

	public static Matcher forMaterial(class_6885<class_8054> material, int minCount) {
		return new Matcher(material, class_6885.method_58563(), minCount);
	}

	public static Matcher forPattern(class_6885<class_8056> pattern, int minCount) {
		return new Matcher(class_6885.method_58563(), pattern, minCount);
	}

	public Map<class_1304, class_1799> getMatchingStacks(class_1309 wearer) {
		Map<class_1304, class_1799> stacks = new HashMap<>();
		for (class_1304 slot : class_1304.values()) {
			class_1799 stack = wearer.method_6118(slot);
			class_1304 shouldBeInSlot = wearer.method_32326(stack);
			if (slot != shouldBeInSlot) continue;

			if (matches(stack)) {
				stacks.put(slot, stack);
			}
		}
		return stacks;
	}

	public boolean matches(class_1309 wearer, class_1799 stack, class_1304 slot) {
		class_1304 shouldBeInSlot = wearer.method_32326(stack);
		return shouldBeInSlot == slot && matches(stack);
	}

	public boolean matches(class_1799 stack) {
		class_8053 trim = stack.method_57824(class_9334.field_49607);
		if (trim == null) return false;

		return matches(trim);
	}

	public boolean matches(class_8053 trim) {
		class_6880<class_8054> material = trim.method_48431();
		class_6880<class_8056> pattern = trim.method_48424();
		boolean matchesMaterial = this.material.method_40241(material) || (!(this.material instanceof class_6885.class_6888) && this.material.method_40247() == 0);
		boolean matchesPattern = this.pattern.method_40241(pattern) || (!(this.pattern instanceof class_6885.class_6888) && this.pattern.method_40247() == 0);
		return matchesMaterial && matchesPattern;
	}
}
