package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_9334;

public record ChangeItemDamageAbility(CountBasedValue amount) implements TrimEntityAbility {
	public static final MapCodec<ChangeItemDamageAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			CountBasedValue.CODEC.fieldOf("amount").forGetter(ChangeItemDamageAbility::amount)
	).apply(instance, ChangeItemDamageAbility::new));

	@Override
	public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
		Map<class_1304, class_1799> equippedStacks = new HashMap<>();
		for (class_1304 slot : class_1304.values()) {
			class_1799 stack = wearer.method_6118(slot);
			if (!stack.method_7960()) {
				equippedStacks.put(slot, stack);
			}
		}
		class_1799 stack = targetSlot != null ? wearer.method_6118(targetSlot) : class_1799.field_8037;
		int amount = (int) this.amount.calculate(items.size());
		if (stack.method_7960()) {
			for (Map.Entry<class_1304, class_1799> stackEntry : equippedStacks.entrySet()) {
				damage(level, wearer, stackEntry.getValue(), stackEntry.getKey(), items.onBreak(), amount);
			}
		} else {
			damage(level, wearer, stack, targetSlot, items.onBreak(), amount);
		}
	}

	private void damage(class_3218 level, class_1309 wearer, class_1799 stack, class_1304 slot, BiConsumer<class_1792, class_1304> onBreak, int amount) {
		if (stack.method_57826(class_9334.field_50072) && stack.method_57826(class_9334.field_49629)) {
			class_3222 owner = wearer instanceof class_3222 ? (class_3222) wearer : null;
			stack.method_7956(amount, level, owner, item -> onBreak.accept(item, slot));
		}
	}

	@Override
	public boolean usesCount() {
		return true;
	}

	@Override
	public MapCodec<? extends TrimEntityAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<ChangeItemDamageAbility> {
		@Override
		public class_5684 getTooltip(class_638 level, ChangeItemDamageAbility element, boolean includeCount) {
			return CompositeContainerComponent.builder()
					.translate("bettertrims.tooltip.ability.change_item_damage.damages", Styler::negative)
					.cycle(builder -> element.amount().getValueComponents(4, includeCount).forEach(builder::textComponent))
					.translate("bettertrims.tooltip.ability.change_item_damage.points", Styler::negative)
					.spaced()
					.build();
		}
	}
}
