package com.bawnorton.bettertrims.property.ability.type.toggle;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
//? if <1.21.8 {
import com.bawnorton.bettertrims.mixin.accessor.ItemStackAccessor;
//?}

public record AttributeAbility(class_2960 id, class_6880<class_1320> attribute, CountBasedValue value, class_1322.class_1323 operation) implements TrimToggleAbility {
	public static final MapCodec<AttributeAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			class_2960.field_25139.fieldOf("id").forGetter(AttributeAbility::id),
			class_1320.field_51575.fieldOf("attribute").forGetter(AttributeAbility::attribute),
			CountBasedValue.CODEC.fieldOf("value").forGetter(AttributeAbility::value),
			class_1322.class_1323.field_45742.fieldOf("operation").forGetter(AttributeAbility::operation)
	).apply(instance, AttributeAbility::new));

	private Multimap<class_6880<class_1320>, class_1322> makeAttributeMap(int count) {
		Multimap<class_6880<class_1320>, class_1322> multimap = HashMultimap.create();
		multimap.put(attribute, getAttributeModifier(count));
		return multimap;
	}

	private class_1322 getAttributeModifier(int count) {
		return new class_1322(id, value.calculate(count), operation);
	}

	@Override
	public void start(class_3218 level, class_1309 wearer, TrimmedItems items) {
		wearer.method_6127().method_59932(makeAttributeMap(items.size()));
	}

	@Override
	public void stop(class_3218 level, class_1309 wearer, TrimmedItems items) {
		wearer.method_6127().method_59935(makeAttributeMap(items.size()));
	}

	@Override
	public boolean usesCount() {
		return true;
	}

	@Override
	public MapCodec<? extends TrimToggleAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<AttributeAbility> {
		@Override
		public @Nullable class_5684 getTooltip(class_638 level, AttributeAbility element, boolean includeCount) {
			boolean distinct = element.value().getValueComponents(4, includeCount).size() == 1;
			List<class_2561> modifiers = new ArrayList<>();
			for (int i = 1; i <= 4; i++) {
				int count = i;
				//? if >=1.21.8 {
				/*ItemAttributeModifiers.Display.attributeModifiers().apply(
				*///?} else {
				((ItemStackAccessor) (Object) class_1799.field_8037).bettertrims$addModifierTooltip(
				 //?}
						component -> {
							if (includeCount && !distinct) {
								component = Styler.trim(class_2561.method_43470("[%d]".formatted(count)))
										.method_27693(": ")
										.method_10852(component);
							}
							modifiers.add(component);
						},
						class_310.method_1551().field_1724,
						element.attribute(),
						element.getAttributeModifier(i)
				);
			}
			return CompositeContainerComponent.builder()
					.cycle(builder -> modifiers.forEach(builder::textComponent))
					.build();
		}
	}
}
