package com.bawnorton.bettertrims.property.ability.type.toggle;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ApplyMobEffectAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public record ToggleMobEffectAbility(class_6880<class_1291> effect, CountBasedValue amplifier,
                                     boolean visible) implements TrimToggleAbility {
	public static final MapCodec<ToggleMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			class_1291.field_51933.fieldOf("effect").forGetter(ToggleMobEffectAbility::effect),
			CountBasedValue.CODEC.fieldOf("amplifier").forGetter(ToggleMobEffectAbility::amplifier),
			Codec.BOOL.optionalFieldOf("visible", true).forGetter(ToggleMobEffectAbility::visible)
	).apply(instance, ToggleMobEffectAbility::new));

	public ToggleMobEffectAbility(class_6880<class_1291> effect, CountBasedValue amplifier) {
		this(effect, amplifier, true);
	}

	private class_1293 getMobEffectInstance(int count) {
		return new class_1293(effect, -1, (int) amplifier.calculate(count), false, visible, true);
	}

	@Override
	public void start(class_3218 level, class_1309 wearer, TrimmedItems items) {
		wearer.method_6092(getMobEffectInstance(items.size()));
	}

	@Override
	public void stop(class_3218 level, class_1309 wearer, TrimmedItems items) {
		wearer.method_6016(effect);
	}

	@Override
	public boolean usesCount() {
		return true;
	}

	@Override
	public MapCodec<? extends TrimToggleAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<ToggleMobEffectAbility> {
		@Override
		public class_5684 getTooltip(class_638 level, ToggleMobEffectAbility element, boolean includeCount) {
			return ApplyMobEffectAbility.TooltipProvider.getEffectTooltip(level,
					includeCount,
					element.effect(),
					element.amplifier(),
					(builder, styler) -> builder.build());
		}
	}
}