package com.bawnorton.bettertrims.property.context;

import com.bawnorton.bettertrims.BetterTrims;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Consumer;
import net.minecraft.class_176;
import net.minecraft.class_181;
import net.minecraft.class_2960;

public final class TrimContextParamSets {
	private static final BiMap<class_2960, class_176> REGISTRY = HashBiMap.create();

	public static final class_176 TRIM_DAMAGE = register(
			"trim_damage",
			builder -> builder.method_781(class_181.field_1226)
					.method_781(TrimContextParams.ITEMS)
					.method_781(class_181.field_24424)
					.method_781(class_181.field_1231)
					.method_780(class_181.field_1227)
					.method_780(class_181.field_1230)
					.method_780(class_181.field_1229) // damaging tool
	);

	public static final class_176 HIT_BLOCK_WITH_HELD_ITEM = register(
			"hit_block_with_held_item",
			builder -> builder.method_781(class_181.field_1226)
					.method_781(class_181.field_24424)
					.method_781(TrimContextParams.ITEMS)
					.method_781(class_181.field_1224)
					.method_781(class_181.field_1229)
	);

	public static final class_176 TRIM_EQUIPMENT = register(
			"trim_equipment",
			builder -> builder.method_781(class_181.field_1226)
					.method_781(class_181.field_24424)
					.method_781(TrimContextParams.ITEMS)
					.method_780(class_181.field_1229)
	);

	public static final class_176 TRIM_ITEM_DAMAGE = register(
			"trim_item_damage",
			builder -> builder.method_781(class_181.field_1229)
					.method_781(class_181.field_1231)
					.method_780(class_181.field_1226)
					.method_780(class_181.field_24424)
					.method_780(class_181.field_1227)
					.method_780(class_181.field_1230)
	);

	public static final class_176 TRIM_ENTITY = register(
			"trim_entity",
			builder -> builder.method_781(class_181.field_1226)
					.method_781(TrimContextParams.ITEMS)
					.method_781(class_181.field_24424)
	);

	private static class_176 register(String name, Consumer<class_176.class_177> ctor) {
		class_176.class_177 builder = new class_176.class_177();
		ctor.accept(builder);
		class_176 contextKeySet = builder.method_782();
		class_2960 resourceLocation = BetterTrims.rl(name);
		if (REGISTRY.put(resourceLocation, contextKeySet) != null) {
			throw new IllegalStateException("Trim parameter set " + resourceLocation + " is already registered");
		} else {
			return contextKeySet;
		}
	}
}
