package com.bawnorton.bettertrims.property.element;

import com.bawnorton.bettertrims.property.Matcher;
import java.util.function.Predicate;
import net.minecraft.class_47;

public final class ConditionalElementMatcher<T extends TrimElement> extends ElementMatcher<T> {
	private final ConditionalElement<T> conditionalElement;

	public ConditionalElementMatcher(Matcher matcher, ConditionalElement<T> conditionalElement) {
		super(matcher, conditionalElement.element());
		this.conditionalElement = conditionalElement;
	}

	@Override
	public Predicate<class_47> conditionChecker() {
		return conditionalElement::matches;
	}

	public ConditionalElement<T> getConditionalElement() {
		return conditionalElement;
	}
}
