/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import com.bawnorton.bettertrims.client.tooltip.component.StackedComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

public abstract class CompositeContainerComponent
implements CompositeComponent {
    protected final List<class_5684> components;
    protected final boolean centred;

    protected CompositeContainerComponent(List<class_5684> components, boolean centred) {
        this.components = components;
        this.centred = centred;
    }

    @Override
    public List<class_5684> getComponents() {
        return this.components;
    }

    public boolean isEmpty() {
        if (this.components.isEmpty()) {
            return true;
        }
        for (class_5684 component : this.components) {
            if (!(component instanceof CompositeContainerComponent)) {
                return false;
            }
            CompositeContainerComponent composite = (CompositeContainerComponent)component;
            if (composite.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isCentred() {
        return this.centred;
    }

    public String toString() {
        return "Composite{%s, centred=%s}".formatted(this.components, this.centred);
    }

    public int hashCode() {
        int result = this.components != null ? this.components.hashCode() : 0;
        result = 31 * result + (this.centred ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeContainerComponent that = (CompositeContainerComponent)obj;
        if (this.centred != that.centred) {
            return false;
        }
        return Objects.equals(this.components, that.components);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CompositeBuilder<CompositeContainerComponent> {
        private boolean spaced = false;
        private boolean vertical = false;
        private boolean centred = false;

        public Builder component(class_5684 component) {
            if (component instanceof CompositeContainerComponent) {
                CompositeContainerComponent composite = (CompositeContainerComponent)component;
                if (composite.centred) {
                    this.centred = true;
                }
            } else if (component instanceof ConditionalComponent) {
                ConditionalComponent conditional = (ConditionalComponent)component;
                class_5684 class_56842 = conditional.ifTrue();
                if (class_56842 instanceof CompositeContainerComponent) {
                    CompositeContainerComponent composite = (CompositeContainerComponent)class_56842;
                    if (composite.centred) {
                        this.centred = true;
                    }
                } else {
                    class_56842 = conditional.ifFalse();
                    if (class_56842 instanceof CompositeContainerComponent) {
                        CompositeContainerComponent composite = (CompositeContainerComponent)class_56842;
                        if (composite.centred) {
                            this.centred = true;
                        }
                    }
                }
            }
            return (Builder)super.component(component);
        }

        public Builder textComponent(class_2561 component) {
            return (Builder)super.textComponent(component);
        }

        public Builder translate(String key, Object ... args) {
            return (Builder)super.translate(key, args);
        }

        public Builder translate(String key, UnaryOperator<class_2583> styler, Object ... args) {
            return (Builder)super.translate(key, styler, args);
        }

        public Builder literal(String text) {
            return (Builder)super.literal(text);
        }

        public Builder literal(String text, UnaryOperator<class_2583> styler) {
            return (Builder)super.literal(text, styler);
        }

        public Builder space() {
            return (Builder)super.space();
        }

        public Builder cycle(Consumer<CyclingComponent.Builder> consumer) {
            CyclingComponent.Builder builder = CyclingComponent.builder();
            consumer.accept(builder);
            CyclingComponent cycling = builder.build();
            return switch (cycling.size()) {
                case 0 -> this;
                case 1 -> this.component(cycling.get(0));
                default -> this.component(cycling);
            };
        }

        public Builder stack(List<? extends class_5684> components, int offset) {
            return this.component(new StackedComponent(components, offset));
        }

        public Builder spaced() {
            if (this.spaced) {
                return this;
            }
            this.spaced = true;
            return this;
        }

        public Builder vertical() {
            if (this.vertical) {
                return this;
            }
            this.vertical = true;
            return this;
        }

        public Builder horizontal() {
            if (!this.vertical) {
                return this;
            }
            this.vertical = false;
            return this;
        }

        public Builder centred(boolean centred) {
            this.centred = centred;
            return this;
        }

        @Override
        public CompositeContainerComponent build() {
            if (!this.spaced) {
                if (this.vertical) {
                    return new Vertical(this.components);
                }
                return new Horizontal(this.components, this.centred);
            }
            ArrayList<class_5684> spacedComponents = new ArrayList<class_5684>();
            for (int i = 0; i < this.components.size(); ++i) {
                spacedComponents.add((class_5684)this.components.get(i));
                if (i >= this.components.size() - 1) continue;
                spacedComponents.add((class_5684)new class_5683(class_2561.method_43470((String)" ").method_30937()));
            }
            if (this.vertical) {
                return new Vertical(spacedComponents);
            }
            return new Horizontal(spacedComponents, this.centred);
        }
    }

    public static final class Vertical
    extends CompositeContainerComponent {
        private int horizontalOffset = 0;

        private Vertical(List<class_5684> components) {
            super(components, false);
        }

        public void setHorizontalOffset(int offset) {
            this.horizontalOffset = offset;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public int method_32661() {
            int totalHeight = 0;
            for (class_5684 component : this.components) {
                totalHeight += component.method_32661();
            }
            return totalHeight;
        }

        public int method_32664(class_327 font) {
            int maxWidth = 0;
            for (class_5684 component : this.components) {
                if (component.method_32664(font) <= maxWidth) continue;
                maxWidth = component.method_32664(font);
            }
            return maxWidth - this.horizontalOffset;
        }

        public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
            int currentY = y;
            int offsetX = x - this.horizontalOffset;
            for (int i = 0; i < this.components.size(); ++i) {
                class_5684 component = (class_5684)this.components.get(i);
                int componentHeight = component.method_32661();
                component.method_32666(font, i == 0 ? x : offsetX, currentY, guiGraphics);
                currentY += componentHeight;
            }
        }

        public void method_32665(class_327 font, int x, int y, Matrix4f matrix, class_4597.class_4598 bufferSource) {
            int currentY = y;
            int offsetX = x - this.horizontalOffset;
            for (int i = 0; i < this.components.size(); ++i) {
                class_5684 component = (class_5684)this.components.get(i);
                int componentHeight = component.method_32661();
                component.method_32665(font, i == 0 ? x : offsetX, currentY, matrix, bufferSource);
                currentY += componentHeight;
            }
        }

        @Override
        public boolean isOneLine() {
            if (this.components.size() > 1) {
                return false;
            }
            if (this.components.isEmpty()) {
                return true;
            }
            class_5684 component = (class_5684)this.components.getFirst();
            if (component instanceof CompositeComponent) {
                CompositeComponent composite = (CompositeComponent)component;
                return composite.isOneLine();
            }
            return true;
        }
    }

    public static final class Horizontal
    extends CompositeContainerComponent {
        private Horizontal(List<class_5684> components, boolean centred) {
            super(components, centred);
        }

        public int method_32661() {
            int maxHeight = 0;
            for (class_5684 component : this.components) {
                if (component.method_32661() <= maxHeight) continue;
                maxHeight = component.method_32661();
            }
            return maxHeight;
        }

        public int method_32664(class_327 font) {
            int totalWidth = 0;
            for (class_5684 component : this.components) {
                totalWidth += component.method_32664(font);
            }
            return totalWidth;
        }

        @Override
        public int getMaxWidth(class_327 font) {
            int totalWidth = 0;
            for (class_5684 component : this.components) {
                if (component instanceof DynamicWidthComponent) {
                    DynamicWidthComponent dynamic = (DynamicWidthComponent)component;
                    totalWidth += dynamic.getMaxWidth(font);
                    continue;
                }
                totalWidth += component.method_32664(font);
            }
            return totalWidth;
        }

        public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
            int currentX = x;
            for (class_5684 component : this.components) {
                int componentWidth = component.method_32664(font);
                component.method_32666(font, currentX, y, guiGraphics);
                currentX += componentWidth;
            }
        }

        public void method_32665(class_327 font, int mouseX, int mouseY, Matrix4f matrix, class_4597.class_4598 bufferSource) {
            int currentX = mouseX;
            int height = this.method_32661();
            for (class_5684 component : this.components) {
                int componentWidth = component.method_32664(font);
                if (this.centred) {
                    int componentHeight = component.method_32661();
                    component.method_32665(font, currentX, mouseY + (height - componentHeight) / 2, matrix, bufferSource);
                } else {
                    component.method_32665(font, currentX, mouseY, matrix, bufferSource);
                }
                currentX += componentWidth;
            }
        }
    }
}

