/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.property.item.type.TrimItemProperty;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5684;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public interface AllOf {
    public static <T, A extends T> MapCodec<A> codec(Codec<T> codec, Function<A, List<T>> getter, Function<List<T>, A> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)codec.listOf().fieldOf("abilities").forGetter(getter)).apply((Applicative)instance, factory));
    }

    public static ToggleAbilities toggleAbilities(TrimToggleAbility ... abilities) {
        return new ToggleAbilities(List.of(abilities));
    }

    public static EntityAbilities entityAbilities(TrimEntityAbility ... abilities) {
        return new EntityAbilities(List.of(abilities));
    }

    public static ValueAbilities valueAbilities(TrimValueAbility ... abilities) {
        return new ValueAbilities(List.of(abilities));
    }

    public static ItemProperties itemProperties(TrimItemProperty ... properties) {
        return new ItemProperties(List.of(properties));
    }

    public record ToggleAbilities(List<TrimToggleAbility> abilities) implements TrimToggleAbility
    {
        public static final MapCodec<ToggleAbilities> CODEC = AllOf.codec(TrimToggleAbility.CODEC, ToggleAbilities::abilities, ToggleAbilities::new);

        @Override
        public void start(class_3218 level, class_1309 wearer, TrimmedItems items) {
            for (TrimToggleAbility ability : this.abilities) {
                ability.start(level, wearer, items);
            }
        }

        @Override
        public void stop(class_3218 level, class_1309 wearer, TrimmedItems items) {
            for (TrimToggleAbility ability : this.abilities) {
                ability.stop(level, wearer, items);
            }
        }

        @Override
        public MapCodec<? extends TrimToggleAbility> codec() {
            return CODEC;
        }

        public static final class TooltipProvider
        implements TrimElementTooltipProvider<ToggleAbilities> {
            @Override
            public class_5684 getTooltip(class_638 level, ToggleAbilities element, boolean includeCount) {
                return com.bawnorton.bettertrims.property.AllOf$TooltipProvider.getAllOfTooltip(level, includeCount, element.abilities());
            }
        }
    }

    public record EntityAbilities(List<TrimEntityAbility> abilities) implements TrimEntityAbility
    {
        public static final MapCodec<EntityAbilities> CODEC = AllOf.codec(TrimEntityAbility.CODEC, EntityAbilities::abilities, EntityAbilities::new);

        @Override
        public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
            for (TrimEntityAbility ability : this.abilities) {
                ability.apply(level, wearer, target, items, targetSlot, origin);
            }
        }

        @Override
        public MapCodec<? extends TrimEntityAbility> codec() {
            return CODEC;
        }

        public static final class TooltipProvider
        implements TrimElementTooltipProvider<EntityAbilities> {
            @Override
            public class_5684 getTooltip(class_638 level, EntityAbilities element, boolean includeCount) {
                return com.bawnorton.bettertrims.property.AllOf$TooltipProvider.getAllOfTooltip(level, includeCount, element.abilities());
            }
        }
    }

    public record ValueAbilities(List<TrimValueAbility> values) implements TrimValueAbility
    {
        public static final MapCodec<ValueAbilities> CODEC = AllOf.codec(TrimValueAbility.CODEC, ValueAbilities::values, ValueAbilities::new);

        @Override
        public float process(int count, class_5819 random, float value) {
            for (TrimValueAbility v : this.values) {
                value = v.process(count, random, value);
            }
            return value;
        }

        @Override
        public MapCodec<? extends TrimValueAbility> codec() {
            return CODEC;
        }

        public static final class TooltipProvider
        implements TrimElementTooltipProvider<ValueAbilities> {
            @Override
            public class_5684 getTooltip(class_638 level, ValueAbilities element, boolean includeCount) {
                return com.bawnorton.bettertrims.property.AllOf$TooltipProvider.getAllOfTooltip(level, includeCount, element.values());
            }
        }
    }

    public record ItemProperties(List<TrimItemProperty> properties) implements TrimItemProperty
    {
        public static final MapCodec<ItemProperties> CODEC = AllOf.codec(TrimItemProperty.CODEC, ItemProperties::properties, ItemProperties::new);

        @Override
        public MapCodec<? extends TrimItemProperty> codec() {
            return CODEC;
        }

        public static final class TooltipProvider
        implements TrimElementTooltipProvider<ItemProperties> {
            @Override
            public class_5684 getTooltip(class_638 level, ItemProperties element, boolean includeCount) {
                return com.bawnorton.bettertrims.property.AllOf$TooltipProvider.getAllOfTooltip(level, includeCount, element.properties());
            }
        }
    }

    public static final class TooltipProvider {
        static CompositeContainerComponent getAllOfTooltip(class_638 level, boolean includeCount, List<? extends TrimElement> elements) {
            boolean moreThanOneUsesCount;
            if (elements.isEmpty()) {
                return null;
            }
            CompositeContainerComponent.Builder allOfBuilder = CompositeContainerComponent.builder().vertical();
            boolean bl = moreThanOneUsesCount = elements.stream().filter(TrimElement::usesCount).count() > 1L;
            if (includeCount && moreThanOneUsesCount) {
                allOfBuilder.cycle(builder -> {
                    for (int i = 1; i <= 4; ++i) {
                        builder.literal("Count [%d]".formatted(i), Styler::trim);
                    }
                });
            }
            for (TrimElement trimElement : elements) {
                TrimElementTooltipProvider<TrimElement> provider = TrimElementTooltips.getProvider(trimElement.getClass());
                class_5684 tooltip = provider.getTooltip(level, trimElement, !moreThanOneUsesCount);
                if (tooltip == null) continue;
                allOfBuilder.component(tooltip);
            }
            return allOfBuilder.build();
        }
    }
}

