/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property;

import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimEntityAbilityRunner;
import com.bawnorton.bettertrims.property.ability.runner.TrimToggleAbilityRunner;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.element.ConditionalElement;
import com.bawnorton.bettertrims.property.element.ConditionalElementMatcher;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public final class TrimProperty {
    public static final Codec<TrimProperty> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Matcher.CODEC.fieldOf("trim").forGetter(TrimProperty::matcher), (App)TrimAbilityComponents.CODEC.optionalFieldOf("abilities", (Object)class_9323.field_49584).forGetter(TrimProperty::abilities), (App)TrimItemPropertyComponents.CODEC.optionalFieldOf("item_properties", (Object)class_9323.field_49584).forGetter(TrimProperty::itemProperties)).apply((Applicative)instance, TrimProperty::new));
    public static final Codec<class_6880<TrimProperty>> CODEC = class_6899.method_40400(BetterTrimsRegistries.Keys.TRIM_PROPERTIES);
    private final Matcher matcher;
    private final class_9323 abilities;
    private final class_9323 itemProperties;
    private final Map<class_9331<?>, List<TrimEntityAbilityRunner<?>>> entityAbilityRunners = new HashMap();
    private final Map<class_9331<?>, List<TrimToggleAbilityRunner<?>>> toggleAbilityRunners = new HashMap();
    private final Map<class_9331<?>, List<TrimValueAbilityRunner<?>>> valueAbilityRunners = new HashMap();
    private final Map<class_9331<?>, List<ConditionalElementMatcher<?>>> elementMatchers = new HashMap();

    public TrimProperty(Matcher matcher, class_9323 abilities, class_9323 itemProperties) {
        this.matcher = matcher;
        this.abilities = abilities;
        this.itemProperties = itemProperties;
    }

    public <A extends TrimEntityAbility> List<TrimEntityAbilityRunner<?>> getEntityAbilityRunners(class_9331<List<ConditionalElement<A>>> type) {
        return this.entityAbilityRunners.computeIfAbsent(type, k -> {
            List elements = (List)this.abilities.method_57829(type);
            if (elements == null) {
                return List.of();
            }
            ArrayList<TrimEntityAbilityRunner<TrimEntityAbility>> runners = new ArrayList<TrimEntityAbilityRunner<TrimEntityAbility>>();
            for (ConditionalElement element : elements) {
                runners.add(new TrimEntityAbilityRunner<TrimEntityAbility>((TrimEntityAbility)element.element(), element::matches, this.matcher));
            }
            return runners;
        });
    }

    public <A extends TrimValueAbility> List<TrimValueAbilityRunner<?>> getValueAbilityRunners(class_9331<List<ConditionalElement<A>>> type) {
        return this.valueAbilityRunners.computeIfAbsent(type, k -> {
            List elements = (List)this.abilities.method_57829(type);
            if (elements == null) {
                return List.of();
            }
            ArrayList<TrimValueAbilityRunner<TrimValueAbility>> runners = new ArrayList<TrimValueAbilityRunner<TrimValueAbility>>();
            for (ConditionalElement element : elements) {
                runners.add(new TrimValueAbilityRunner<TrimValueAbility>((TrimValueAbility)element.element(), element::matches, this.matcher));
            }
            return runners;
        });
    }

    public <A extends TrimToggleAbility> List<TrimToggleAbilityRunner<?>> getToggleAbilityRunners(class_9331<List<ConditionalElement<A>>> type) {
        return this.toggleAbilityRunners.computeIfAbsent(type, k -> {
            List elements = (List)this.abilities.method_57829(type);
            if (elements == null) {
                return List.of();
            }
            ArrayList<TrimToggleAbilityRunner<TrimToggleAbility>> runners = new ArrayList<TrimToggleAbilityRunner<TrimToggleAbility>>();
            for (ConditionalElement element : elements) {
                runners.add(new TrimToggleAbilityRunner<TrimToggleAbility>((TrimToggleAbility)element.element(), element::matches, this.matcher));
            }
            return runners;
        });
    }

    public <A extends TrimElement> List<ConditionalElementMatcher<?>> getAbilityElements(class_9331<List<ConditionalElement<A>>> type) {
        return this.elementMatchers.computeIfAbsent(type, k -> this.getElements(type, this.abilities));
    }

    public <A extends TrimElement> List<ConditionalElementMatcher<?>> getItemPropertyElements(class_9331<List<ConditionalElement<A>>> type) {
        return this.elementMatchers.computeIfAbsent(type, k -> this.getElements(type, this.itemProperties));
    }

    @NotNull
    private <A extends TrimElement> List<ConditionalElementMatcher<?>> getElements(class_9331<List<ConditionalElement<A>>> type, class_9323 elementMap) {
        List elements = (List)elementMap.method_57829(type);
        if (elements == null) {
            return List.of();
        }
        ArrayList matchers = new ArrayList();
        for (ConditionalElement element : elements) {
            matchers.add(new ConditionalElementMatcher(this.matcher, element));
        }
        return matchers;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    private class_9323 abilities() {
        return this.abilities;
    }

    private class_9323 itemProperties() {
        return this.itemProperties;
    }

    public String toString() {
        return "TrimProperty{matcher=%s, abilities=%s, itemProperties=%s}".formatted(this.matcher, this.abilities, this.itemProperties);
    }

    public static Builder builder(Matcher matcher) {
        return new Builder(matcher);
    }

    public static class Builder {
        private final Map<class_9331<?>, List<?>> abilityLists = new HashMap();
        private final class_9323.class_9324 abilityMapBuilder = class_9323.method_57827();
        private final Map<class_9331<?>, List<?>> itemPropertyLists = new HashMap();
        private final class_9323.class_9324 itemPropertiesMapBuilder = class_9323.method_57827();
        private final Matcher matcher;

        public Builder(Matcher matcher) {
            this.matcher = matcher;
        }

        public <A extends TrimElement> Builder ability(class_9331<List<ConditionalElement<A>>> type, A ability) {
            this.getAbilityList(type).add(new ConditionalElement<A>(ability, Optional.empty()));
            return this;
        }

        public <A extends TrimElement> Builder ability(class_9331<List<ConditionalElement<A>>> type, A ability, class_5341.class_210 requirements) {
            this.getAbilityList(type).add(new ConditionalElement<A>(ability, Optional.of(requirements.build())));
            return this;
        }

        public <A extends TrimElement> Builder itemProperty(class_9331<List<ConditionalElement<A>>> type, A itemProperty) {
            this.getItemProperties(type).add(new ConditionalElement<A>(itemProperty, Optional.empty()));
            return this;
        }

        public <A extends TrimElement> Builder itemProperty(class_9331<List<ConditionalElement<A>>> type, A itemProperty, class_5341.class_210 requirements) {
            this.getItemProperties(type).add(new ConditionalElement<A>(itemProperty, Optional.of(requirements.build())));
            return this;
        }

        private <A> List<A> getAbilityList(class_9331<List<A>> type) {
            return this.abilityLists.computeIfAbsent(type, k -> {
                ArrayList list = new ArrayList();
                this.abilityMapBuilder.method_57840(type, list);
                return list;
            });
        }

        private <A> List<A> getItemProperties(class_9331<List<A>> type) {
            return this.itemPropertyLists.computeIfAbsent(type, k -> {
                ArrayList list = new ArrayList();
                this.itemPropertiesMapBuilder.method_57840(type, list);
                return list;
            });
        }

        public TrimProperty build() {
            return new TrimProperty(this.matcher, this.abilityMapBuilder.method_57838(), this.itemPropertiesMapBuilder.method_57838());
        }
    }
}

