/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.version.VRegistry;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10184;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_1934;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4553;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_9789;

public interface PlayerPredicateTooltip {
    public static void addToBuilder(class_638 level, class_4553 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional input;
        class_2096.class_2100 playerLevel = predicate.comp_1817();
        PlayerPredicateTooltip.addLevelToBuilder(level, playerLevel, state, builder);
        class_9789 gameType = predicate.comp_1818();
        PlayerPredicateTooltip.addGameTypeToBuilder(level, gameType, state, builder);
        List stats = predicate.comp_1819();
        PlayerPredicateTooltip.addStatsToBuilder(level, stats, state, builder);
        Object2BooleanMap recipes = predicate.comp_1820();
        PlayerPredicateTooltip.addRecipesToBuilder(level, recipes, state, builder);
        Map advancements = predicate.comp_1821();
        PlayerPredicateTooltip.addAdvancementsToBuilder(level, advancements, state, builder);
        Optional lookingAt = predicate.comp_1822();
        if (lookingAt.isPresent()) {
            PlayerPredicateTooltip.addLookingAtToBuilder(level, (class_2048)lookingAt.orElseThrow(), state, builder);
        }
        if ((input = predicate.comp_3182()).isPresent()) {
            PlayerPredicateTooltip.addInputToBuilder(level, (class_10184)input.orElseThrow(), state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("player.%s".formatted(key));
    }

    public static void addLevelToBuilder(class_638 level, class_2096.class_2100 playerLevel, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (!playerLevel.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(PlayerPredicateTooltip.key("level"), false, playerLevel, state, builder);
        }
    }

    public static void addGameTypeToBuilder(class_638 level, class_9789 gameType, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        List types = gameType.comp_2829();
        if (!types.isEmpty()) {
            PredicateTooltip.addEnumListToBuilder(PlayerPredicateTooltip.key("game_type"), types, class_1934::method_32763, state, builder);
        }
    }

    public static void addStatsToBuilder(class_638 level, List<class_4553.class_8749<?>> stats, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (stats.isEmpty()) {
            return;
        }
        CompositeContainerComponent.Builder statsBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("stats.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> {
            for (class_4553.class_8749 stat : stats) {
                CompositeContainerComponent.Builder cycledBuilder = CompositeContainerComponent.builder();
                cycledBuilder.textComponent((class_2561)class_2561.method_43469((String)PlayerPredicateTooltip.key("stat"), (Object[])new Object[]{Styler.name(stat.comp_1825().method_30739().method_27661())})).space().literal("[", Styler::condition);
                PredicateTooltip.addMinMaxToBuilder(PlayerPredicateTooltip.key("stat.range"), false, stat.comp_1827(), state, cycledBuilder);
                cycledBuilder.literal("]", Styler::condition);
                cycleBuilder.component(cycledBuilder.build());
            }
        });
        builder.component(statsBuilder.build());
    }

    public static void addRecipesToBuilder(class_638 level, Object2BooleanMap<class_5321<class_1860<?>>> recipes, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (recipes.isEmpty()) {
            return;
        }
        CompositeContainerComponent.Builder recipesBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("recipes.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> recipes.object2BooleanEntrySet().forEach(entry -> {
            boolean knows = entry.getBooleanValue();
            class_2960 id = ((class_5321)entry.getKey()).method_29177();
            class_5250 name = Styler.name(class_2561.method_43470((String)id.toString()));
            cycleBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(PlayerPredicateTooltip.key("recipe.%s".formatted(knows ? "knows" : "does_not_know")), Styler::condition, new Object[]{name})).build());
        }));
        builder.component(recipesBuilder.build());
    }

    public static void addAdvancementsToBuilder(class_638 level, Map<class_2960, class_4553.class_4556> advancements, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (advancements.isEmpty()) {
            return;
        }
        class_2378 registry = VRegistry.get(level, class_7924.field_52177);
        CompositeContainerComponent.Builder advancementsBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("advancements.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> advancements.forEach((id, advancementPredicate) -> {
            class_161 advancement = registry.method_17966(id).orElse(null);
            if (advancement == null) {
                return;
            }
            class_5250 name = Styler.name(((class_2561)advancement.comp_1918().orElse(class_2561.method_43470((String)id.toString()))).method_27661());
            CompositeContainerComponent.Builder advancementBuilder = CompositeContainerComponent.builder().textComponent((class_2561)name);
            class_4553.class_4556 class_45562 = advancementPredicate;
            Objects.requireNonNull(class_45562);
            class_4553.class_4556 selector0$temp = class_45562;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_4553.class_4555.class, class_4553.class_4554.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    class_4553.class_4555 donePredicate = (class_4553.class_4555)selector0$temp;
                    boolean isDone = donePredicate.comp_1824();
                    advancementBuilder.translate(PlayerPredicateTooltip.key("advancement.%s".formatted(isDone ? "completed" : "not_completed")), Styler::value, new Object[0]);
                    break;
                }
                case 1: {
                    class_4553.class_4554 criterionsPredicate = (class_4553.class_4554)selector0$temp;
                    Object2BooleanMap criterions = criterionsPredicate.comp_1823();
                    if (criterions.isEmpty()) break;
                    advancementBuilder.space().literal("[");
                    boolean useAnd = false;
                    for (Map.Entry entry : criterions.object2BooleanEntrySet()) {
                        if (useAnd) {
                            advancementBuilder.literal(" & ");
                        }
                        useAnd = true;
                        String criterion = (String)entry.getKey();
                        boolean achieved = (Boolean)entry.getValue();
                        advancementBuilder.translate(PlayerPredicateTooltip.key("advancement.criterion.%s".formatted(achieved ? "achieved" : "not_achieved")), Styler::value, new Object[]{Styler.name(class_2561.method_43470((String)criterion))});
                    }
                    advancementBuilder.literal("]");
                    break;
                }
            }
            cycleBuilder.component(advancementBuilder.build());
        }));
        builder.component(advancementsBuilder.build());
    }

    public static void addLookingAtToBuilder(class_638 level, class_2048 entityPredicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        EntityPredicateTooltip.addEntityPredicateToBuilder(level, "looking_at", entityPredicate, state, builder);
    }

    public static void addInputToBuilder(class_638 level, class_10184 inputPredicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map<String, Optional> inputs = Map.of("forward", inputPredicate.comp_3152(), "backward", inputPredicate.comp_3153(), "left", inputPredicate.comp_3154(), "right", inputPredicate.comp_3155(), "jump", inputPredicate.comp_3156(), "sneak", inputPredicate.comp_3157(), "sprint", inputPredicate.comp_3158());
        CompositeContainerComponent.Builder inputBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("input.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> inputs.forEach((inputName, input) -> {
            if (input.isPresent()) {
                boolean isHeld = input.orElse(false);
                cycleBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(PlayerPredicateTooltip.key("input.%s.%s".formatted(inputName, isHeld ? "true" : "false")), Styler::value, new Object[0])).build());
            }
        }));
        builder.component(inputBuilder.build());
    }
}

