/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record ApplyMobEffectAbility(class_6880<class_1291> effect, CountBasedValue amplifier, CountBasedValue duration) implements TrimEntityAbility
{
    public static final MapCodec<ApplyMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1291.field_51933.fieldOf("effect").forGetter(ApplyMobEffectAbility::effect), (App)CountBasedValue.CODEC.fieldOf("amplifier").forGetter(ApplyMobEffectAbility::amplifier), (App)CountBasedValue.CODEC.fieldOf("duration").forGetter(ApplyMobEffectAbility::duration)).apply((Applicative)instance, ApplyMobEffectAbility::new));

    @Override
    public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            int count = items.size();
            int amplifier = (int)this.amplifier.calculate(count);
            int duration = (int)this.duration.calculate(count) * 20;
            if (amplifier < 0 || duration <= 0) {
                return;
            }
            class_1293 effectInstance = new class_1293(this.effect, duration, amplifier);
            living.method_6092(effectInstance);
        }
    }

    @Override
    public boolean usesCount() {
        return true;
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<ApplyMobEffectAbility> {
        @Override
        public class_5684 getTooltip(class_638 level, ApplyMobEffectAbility element, boolean includeCount) {
            return TooltipProvider.getEffectTooltip(level, includeCount, element.effect(), element.amplifier(), (builder, styler) -> ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.ability.apply_mob_effect.for", (UnaryOperator)styler, new Object[0])).cycle(durationCycler -> element.duration().getValueComponents(4, includeCount, f -> class_2561.method_43470((String)"%.0f".formatted(f)), f -> f.floatValue() > 0.0f).forEach(durationCycler::textComponent)).translate("bettertrims.tooltip.ability.apply_mob_effect.seconds", (UnaryOperator)styler, new Object[0])).build());
        }

        public static class_5684 getEffectTooltip(class_638 level, boolean includeCount, class_6880<class_1291> effect, CountBasedValue amplifier, BiFunction<CompositeContainerComponent.Builder, UnaryOperator<class_2583>, CompositeContainerComponent> builder) {
            class_2378 registry = VRegistry.get(level, class_7924.field_41208);
            class_1291 mobEffect = (class_1291)effect.method_40229().map(arg_0 -> registry.method_31140(arg_0), Function.identity());
            class_5250 name = Styler.name(mobEffect.method_5560().method_27661());
            List<class_2561> amplifierValues = amplifier.getValueComponents(4, includeCount, f -> class_2561.method_43471((String)"enchantment.level.%s".formatted("%.0f".formatted(Float.valueOf(f.floatValue() + 1.0f)))), f -> f.floatValue() >= 0.0f);
            return builder.apply(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.apply_mob_effect.grants", (UnaryOperator)Styler.sentiment(mobEffect.method_5573()), new Object[0])).textComponent((class_2561)name).cycle(amplifierCycler -> amplifierValues.forEach(amplifierCycler::textComponent)).spaced(), Styler.sentiment(mobEffect.method_5573()));
        }
    }
}

