package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_638;
import net.minecraft.class_8110;
import net.minecraft.class_8129;

public interface DamageSourcePredicateTooltip {
	static String key(String key) {
		return PredicateTooltip.key("damage_source.%s".formatted(key));
	}

	static void addToBuilder(class_638 level, class_2022 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_2048> directEntity = predicate.comp_1741();
		if (directEntity.isPresent()) {
			EntityPredicateTooltip.addEntityPredicateToBuilder(level, "damage_source.direct", directEntity.orElseThrow(), state, builder);
		}

		Optional<class_2048> sourceEntity = predicate.comp_1742();
		if (sourceEntity.isPresent()) {
			EntityPredicateTooltip.addEntityPredicateToBuilder(level, "damage_source.source", sourceEntity.orElseThrow(), state, builder);
		}

		Optional<Boolean> direct = predicate.comp_2793();
		if (direct.isPresent()) {
			addDirectToBuilder(level, direct.orElseThrow(), state, builder);
		}

		List<class_8129<class_8110>> projectile = predicate.comp_1740();
		if (!projectile.isEmpty()) {
			addTagsToBuilder(level, projectile, state, builder);
		}
	}

	static void addDirectToBuilder(class_638 level, Boolean direct, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		builder.component(CompositeContainerComponent.builder()
				.space()
				.translate(key("is_direct.%s".formatted(direct ? "true" : "false")), Styler::value)
				.build());
	}

	static void addTagsToBuilder(class_638 level, List<class_8129<class_8110>> tags, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PredicateTooltip.addTagsToBuilder(key("tags"), tags, state, builder);
	}
}
