package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

import static com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip.addMinMaxToBuilder;

public interface LocationPredicateTooltip {
	static void addToBuilder(class_638 level, class_2090 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_2090.class_8747> position = predicate.comp_1794();
		if (position.isPresent()) {
			addPositionPredicateToBuilder(level, position.orElseThrow(), state, builder);
		}

		Optional<class_6885<class_1959>> biomes = predicate.comp_2375();
		if (biomes.isPresent()) {
			addBiomesToBuilder(level, biomes.orElseThrow(), state, builder);
		}

		Optional<class_6885<class_3195>> structures = predicate.comp_2376();
		if (structures.isPresent()) {
			addStructuresToBuilder(level, structures.orElseThrow(), state, builder);
		}

		Optional<class_5321<class_1937>> dimension = predicate.comp_1797();
		if (dimension.isPresent()) {
			addDimensionToBuilder(level, dimension.orElseThrow(), state, builder);
		}

		Optional<Boolean> smokey = predicate.comp_1798();
		if (smokey.isPresent()) {
			addSmokeyToBuilder(level, smokey.orElseThrow(), state, builder);
		}

		Optional<class_4552> light = predicate.comp_1799();
		if (light.isPresent()) {
			addLightPredicateToBuilder(level, light.orElseThrow(), state, builder);
		}

		Optional<class_4550> block = predicate.comp_1800();
		if (block.isPresent()) {
			addBlockPredicateToBuilder(level, block.orElseThrow(), state, builder);
		}

		Optional<class_4551> fluid = predicate.comp_1801();
		if (fluid.isPresent()) {
			addFluidPredicateToBuilder(level, fluid.orElseThrow(), state, builder);
		}

		Optional<Boolean> canSeeSky = predicate.comp_2771();
		if (canSeeSky.isPresent()) {
			addCanSeeSkyToBuilder(level, canSeeSky.orElseThrow(), state, builder);
		}
	}

	static String key(String key) {
		return PredicateTooltip.key("location.%s".formatted(key));
	}

	static void addPositionPredicateToBuilder(class_638 level, class_2090.class_8747 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2099 x = predicate.comp_1802();
		class_2096.class_2099 y = predicate.comp_1803();
		class_2096.class_2099 z = predicate.comp_1804();

		CompositeContainerComponent.Builder positionBuilder = CompositeContainerComponent.builder()
				.space();
		boolean useAnd = false;
		if (!x.method_9041()) {
			addMinMaxToBuilder(key("position.x"), useAnd, x.comp_1805().orElse(null), x.comp_1806().orElse(null), state, positionBuilder);
			useAnd = true;
		}
		if (!y.method_9041()) {
			addMinMaxToBuilder(key("position.y"), useAnd, y.comp_1805().orElse(null), y.comp_1806().orElse(null), state, positionBuilder);
			useAnd = true;
		}
		if (!z.method_9041()) {
			addMinMaxToBuilder(key("position.z"), useAnd, z.comp_1805().orElse(null), z.comp_1806().orElse(null), state, positionBuilder);
		}
		builder.component(positionBuilder.build());
	}

	static void addBiomesToBuilder(class_638 level, class_6885<class_1959> biomes, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PredicateTooltip.addRegisteredElementsToBuilder(level, key("biome"), class_7924.field_41236, biomes, state, builder);
	}

	static void addStructuresToBuilder(class_638 level, class_6885<class_3195> structures, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PredicateTooltip.addRegisteredElementsToBuilder(level, key("structure"), class_7924.field_41246, structures, state, builder);
	}

	static void addDimensionToBuilder(class_638 level, class_5321<class_1937> dimension, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2561 dimensionName = Styler.name(class_2561.method_43470(dimension.toString()));
		builder.component(CompositeContainerComponent.builder()
				.space()
				.translate(key("dimension"), Styler::condition)
				.space()
				.textComponent(dimensionName)
				.build());
	}

	static void addSmokeyToBuilder(class_638 level, boolean smokey, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		builder.component(CompositeContainerComponent.builder().space().translate(key("smokey.%s".formatted(smokey)), Styler::value).build());
	}

	static void addLightPredicateToBuilder(class_638 level, class_4552 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2100 composite = predicate.comp_1791();
		if (composite.method_9041()) {
			builder.space().translate(key("light.any"), Styler::value);
		} else {
			addMinMaxToBuilder(key("light.level"), false, composite.comp_1805().orElse(null), composite.comp_1806().orElse(null), state, builder);
		}
	}

	static void addBlockPredicateToBuilder(class_638 level, class_4550 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		BlockPredicateTooltip.addToBuilder(level, predicate, state, builder);
	}

	static void addFluidPredicateToBuilder(class_638 level, class_4551 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		FluidPredicateTooltip.addToBuilder(level, predicate, state, builder);
	}

	static void addCanSeeSkyToBuilder(class_638 level, boolean canSeeSky, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		builder.component(CompositeContainerComponent.builder().space().translate(key("can_see_sky.%s".formatted(canSeeSky)), Styler::value).build());
	}
}
