package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact.*;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public final class ExactDataComponentPredicateTooltipAdders {
	private static final Map<class_9331<?>, ExactAdder<?>> EXACT_ADDERS = new HashMap<>();

	static {
		register(class_9334.field_49628, new CustomDataExactAdder("custom"));
		register(class_9334.field_50071, ExactAdder.simple((maxStackSize, builder) ->
				builder.translate(key("max_stack_size"), Styler::condition, Styler.number(maxStackSize))
		));
		register(class_9334.field_50072, ExactAdder.simple((maxDamage, builder) ->
				builder.translate(key("max_damage"), Styler::condition, Styler.number(maxDamage))
		));
		register(class_9334.field_49629, ExactAdder.simple((damage, builder) ->
				builder.translate(key("damage"), Styler::condition, Styler.number(damage))
		));
		register(class_9334.field_49630, ExactAdder.simple((unit, builder) ->
				builder.translate(key("unbreakable"), Styler::condition)
		));
		register(class_9334.field_49631, ExactAdder.simple((name, builder) ->
				builder.translate(key("custom_name"), Styler::condition, Styler.value(name.method_27661()))
		));
		register(class_9334.field_50239, ExactAdder.simple((name, builder) ->
				builder.translate(key("item_name"), Styler::condition, Styler.value(name.method_27661()))
		));
		register(class_9334.field_49632, new ItemLoreExactAdder());
		register(class_9334.field_50073, ExactAdder.simple((rarity, builder) ->
				builder.translate(key("rarity"), Styler::condition, class_2561.method_43470(rarity.name()).method_27692(rarity.method_58413()))
		));
		register(class_9334.field_49633, new EnchantmentsExactAdder("enchantments"));
		register(class_9334.field_49634, new AdventureModePredicateExactAdder("can_place_on"));
		register(class_9334.field_49635, new AdventureModePredicateExactAdder("can_break"));
		register(class_9334.field_49636, new ItemAttributeModifiersExactAdder());
		register(class_9334.field_49637, new CustomModelDataExactAdder());
		register(class_9334.field_49639, ExactAdder.simple((repairCost, builder) ->
				builder.translate(key("repair_cost"), Styler::condition, Styler.number(class_2561.method_43470(repairCost.toString())))
		));
		register(class_9334.field_49640, ExactAdder.simple((unit, builder) ->
				builder.translate(key("creative_slot_lock"), Styler::condition)
		));
		register(class_9334.field_49641, ExactAdder.simple((glint, builder) ->
				builder.translate(key("enchantment_glint_override.%s".formatted(glint.toString())), Styler::condition)
		));
		register(class_9334.field_49642, ExactAdder.simple((unit, builder) ->
				builder.translate(key("intangible_projectile"), Styler::condition)
		));
		register(class_9334.field_50075, new FoodPropertiesExactAdder());
		register(class_9334.field_50077, new ToolExactAdder());
		register(class_9334.field_49643, new EnchantmentsExactAdder("stored_enchantments"));
		register(class_9334.field_49644, new DyedItemColorExactAdder());
		register(class_9334.field_49645, new MapItemColorExactAdder());
		register(class_9334.field_49646, ExactAdder.simple((mapId, builder) ->
				builder.translate(key("map_id"), Styler::condition, Styler.number(mapId.comp_2315()))
		));
		register(class_9334.field_49647, new MapDecorationsExactAdder());
		register(class_9334.field_49648, ExactAdder.ofEnum("map_post_processing"));
		register(class_9334.field_49649, new ChargedProjectilesExactAdder());
		register(class_9334.field_49650, new BundleContentsExactAdder());
		register(class_9334.field_49651, new PotionContentsExactAdder());
		register(class_9334.field_49652, new SuspiciousStewEffectsExactAdder());
		register(class_9334.field_49653, new WritableBookContentExactAdder());
		register(class_9334.field_49606, new WrittenBookContentExactAdder());
		register(class_9334.field_49607, new ArmorTrimExactAdder());
		register(class_9334.field_49608, new DebugStickStateExactAdder());
		register(class_9334.field_49610, new CustomDataExactAdder("bucket_entity"));
		register(class_9334.field_52175, new JukeboxPlayableExactAdder());
		register(class_9334.field_49614, new LodestoneTrackerExactAdder());
		register(class_9334.field_49615, new FireworkExplosionExactAdder());
		register(class_9334.field_49616, new FireworksExactAdder());
		register(class_9334.field_49617, new ResolvableProfileExactAdder());
		register(class_9334.field_49618, ExactAdder.simple((sound, builder) ->
				builder.translate(key("note_block_sound"), Styler::condition, Styler.name(class_2561.method_43470(sound.toString())))
		));
		register(class_9334.field_49619, new BannerPatternLayersExactAdder());
		register(class_9334.field_49620, ExactAdder.ofEnum("base_color"));
		register(class_9334.field_49621, new PotDecorationsExactAdder());
		register(class_9334.field_49622, new ItemContainerContentsExactAdder());
		register(class_9334.field_49623, new BlockItemStatePropertiesExactAdder());
		register(class_9334.field_49626, new SeededContainerLootExactAdder());
		//? if >=1.21.8 {
		//? if >=1.21.10 {
		/*register(DataComponents.ENTITY_DATA, new TypedEntityDataExactAdder<>("entity"));
		register(DataComponents.BLOCK_ENTITY_DATA, new TypedEntityDataExactAdder<>("block_entity"));
		*///?} else {
		register(class_9334.field_49609, new CustomDataExactAdder("entity"));
		register(class_9334.field_49611, new CustomDataExactAdder("block_entity"));
		//?}
		register(class_9334.field_54199, ExactAdder.simple((itemModel, builder) ->
				builder.translate(key("item_model"), Styler::condition, Styler.value(class_2561.method_43470(itemModel.toString())))
		));
		register(class_9334.field_56400, new TooltipDisplayExactAdder());
		register(class_9334.field_53964, new ConsumableExactAdder());
		register(class_9334.field_53965, new UseRemainderExactAdder());
		register(class_9334.field_53966, new UseCooldownExactAdder());
		register(class_9334.field_54273, new DamageResistantExactAdder());
		register(class_9334.field_55878, new WeaponExactAdder());
		register(class_9334.field_53695, ExactAdder.simple((enchantable, builder) ->
				builder.translate(key("enchantable"), Styler::condition, Styler.number(enchantable.comp_2938()))
		));
		register(class_9334.field_54196, new EquippableExactAdder());
		register(class_9334.field_53696, new RepairableExactAdder());
		register(class_9334.field_54197, ExactAdder.simple((unit, builder) ->
				builder.translate(key("glider"), Styler::condition)
		));
		register(class_9334.field_54198, ExactAdder.simple((tooltipStyle, builder) ->
				builder.translate(key("tooltip_style"), Styler::condition, Styler.value(class_2561.method_43470(tooltipStyle.toString()))
				)));
		register(class_9334.field_54274, new DeathProtectionExactAdder());
		register(class_9334.field_56396, new BlocksAttacksExactAdder());
		register(class_9334.field_55879, ExactAdder.simple((durationScale, builder) ->
				builder.translate(key("potion_duration_scale"), Styler::condition, Styler.number(durationScale))
		));
		register(class_9334.field_56397, new ProvidesTrimMaterialExactAdder());
		register(class_9334.field_49625, new LockCodeExactAdder());
		register(class_9334.field_50238, ExactAdder.simple((amplifier, builder) ->
				builder.translate(key("ominous_bottle_amplifier"), Styler::condition, Styler.number(amplifier.comp_3090()))
		));
		register(class_9334.field_49612, new InstrumentComponentExactAdder());
		register(class_9334.field_49613, new RecipeResourceKeyListExactAdder());
		register(class_9334.field_49624, new BeesExactAdder());
		register(class_9334.field_56399, new SoundEventHolderExactAdder());
		register(class_9334.field_56145, new VillagerTypeHolderExactAdder());
		register(class_9334.field_56146, new WolfVariantHolderExactAdder());
		register(class_9334.field_57109, new WolfSoundVariantHolderExactAdder());
		register(class_9334.field_56147, ExactAdder.ofEnum("wolf_collar"));
		register(class_9334.field_56148, ExactAdder.ofEnum("fox_variant"));
		register(class_9334.field_56149, ExactAdder.ofEnum("salmon_size"));
		register(class_9334.field_56150, ExactAdder.ofEnum("parrot_variant"));
		register(class_9334.field_56151, ExactAdder.ofEnum("tropical_fish_pattern"));
		register(class_9334.field_56152, ExactAdder.ofEnum("tropical_fish_base_color"));
		register(class_9334.field_56132, ExactAdder.ofEnum("tropical_fish_pattern_color"));
		register(class_9334.field_56133, ExactAdder.ofEnum("mooshroom_variant"));
		register(class_9334.field_56134, ExactAdder.ofEnum("rabbit_variant"));
		register(class_9334.field_56135, new PigVariantHolderExactAdder());
		register(class_9334.field_56508, new CowVariantHolderExactAdder());
		register(class_9334.field_56595, new ChickenVariantEitherHolderExactAdder());
		register(class_9334.field_56136, new FrogVariantHolderExactAdder());
		register(class_9334.field_56137, ExactAdder.ofEnum("horse_variant"));
		register(class_9334.field_56138, new PaintingVariantHolderExactAdder());
		register(class_9334.field_56139, ExactAdder.ofEnum("llama_variant"));
		register(class_9334.field_56140, ExactAdder.ofEnum("axolotl_variant"));
		register(class_9334.field_56141, new CatVariantHolderExactAdder());
		register(class_9334.field_56142, ExactAdder.ofEnum("cat_collar"));
		register(class_9334.field_56143, ExactAdder.ofEnum("sheep_color"));
		register(class_9334.field_56144, ExactAdder.ofEnum("shulker_color"));
		//?} else {
		/*register(DataComponents.LOCK, ExactAdder.simple((lock, builder) ->
				builder.translate(key("lock"), Styler::condition, Styler.value(Component.literal(lock.key())))
		));
		register(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, ExactAdder.simple((amplifier, builder) ->
				builder.translate(key("ominous_bottle_amplifier"), Styler::condition, Styler.number(amplifier))
		));
		register(DataComponents.INSTRUMENT, new InstrumentHolderExactAdder());
		register(DataComponents.RECIPES, new IdListExactAdder());
		register(DataComponents.BEES, new BeehiveBlockEntityOccupantListExactAdder());
		register(DataComponents.FIRE_RESISTANT, ExactAdder.simple((unit, builder) ->
				builder.translate(key("fire_resistant"), Styler::condition)
		));
		*///?}
	}

	private static <T> void register(class_9331<T> type, ExactAdder<T> adder) {
		if (EXACT_ADDERS.containsKey(type)) {
			throw new IllegalStateException("Duplicate data component type: " + type);
		}
		EXACT_ADDERS.put(type, adder);
	}

	@SuppressWarnings("unchecked")
	public static void addToBuilder(class_638 level, class_9331<?> type, Object object, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		ExactAdder<Object> adder = (ExactAdder<Object>) EXACT_ADDERS.getOrDefault(type, ExactAdder.UNKNOWN.apply(type));
		adder.addToBuilder(level, object, state, builder);
	}

	public static String key(String key) {
		return PredicateTooltip.key("data.exact.%s".formatted(key));
	}
}
