package com.bawnorton.bettertrims.mixin.property.ability.targeting;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4834;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_4834.class)
abstract class PiglinSpecificSensorMixin {
	@WrapOperation(
			method = "doTick",
			at = @At(
					value = "INVOKE",
					//? if >=1.21.8 {
					target = "Lnet/minecraft/world/entity/monster/piglin/PiglinAi;isWearingSafeArmor(Lnet/minecraft/world/entity/LivingEntity;)Z"
					//?} else {
					/*target = "Lnet/minecraft/world/entity/monster/piglin/PiglinAi;isWearingGold(Lnet/minecraft/world/entity/LivingEntity;)Z"
					*///?}
			)
	)
	private static boolean isWearingSafeTrim(class_1309 target, Operation<Boolean> original, class_3218 level, class_1309 entity) {
		boolean wearingSafeArmour = original.call(target);
		if (wearingSafeArmour) return true;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (ElementMatcher<?> ability : property.getAbilityElements(TrimAbilityComponents.PIGLIN_SAFE)) {
				if (ability.getElement() instanceof PiglinSafeAbility piglinSafeAbility
						&& ability.matches(target, TrimContexts.entity(level, ability.getMatchingItems(target), entity, entity.method_19538()))
						&& piglinSafeAbility.entityLooksForGold(entity)) {
					return true;
				}
			}
		}
		return false;
	}
}
