package com.bawnorton.bettertrims.property;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimEntityAbilityRunner;
import com.bawnorton.bettertrims.property.ability.runner.TrimToggleAbilityRunner;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.element.ConditionalElement;
import com.bawnorton.bettertrims.property.element.ConditionalElementMatcher;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_9323;
import net.minecraft.class_9331;

public final class TrimProperty {
	public static final Codec<TrimProperty> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group(
			Matcher.CODEC.fieldOf("trim").forGetter(TrimProperty::matcher),
			TrimAbilityComponents.CODEC.optionalFieldOf("abilities", class_9323.field_49584).forGetter(TrimProperty::abilities),
			TrimItemPropertyComponents.CODEC.optionalFieldOf("item_properties", class_9323.field_49584).forGetter(TrimProperty::itemProperties)
	).apply(instance, TrimProperty::new));

	public static final Codec<class_6880<TrimProperty>> CODEC = class_6899.method_40400(BetterTrimsRegistries.Keys.TRIM_PROPERTIES);

	private final Matcher matcher;
	private final class_9323 abilities;
	private final class_9323 itemProperties;

	private final Map<class_9331<?>, List<TrimEntityAbilityRunner<?>>> entityAbilityRunners = new HashMap<>();
	private final Map<class_9331<?>, List<TrimToggleAbilityRunner<?>>> toggleAbilityRunners = new HashMap<>();
	private final Map<class_9331<?>, List<TrimValueAbilityRunner<?>>> valueAbilityRunners = new HashMap<>();
	private final Map<class_9331<?>, List<ConditionalElementMatcher<?>>> elementMatchers = new HashMap<>();

	public TrimProperty(Matcher matcher, class_9323 abilities, class_9323 itemProperties) {
		this.matcher = matcher;
		this.abilities = abilities;
		this.itemProperties = itemProperties;
	}

	public <A extends TrimEntityAbility> List<TrimEntityAbilityRunner<?>> getEntityAbilityRunners(class_9331<List<ConditionalElement<A>>> type) {
		return entityAbilityRunners.computeIfAbsent(type, k -> {
			List<ConditionalElement<A>> elements = this.abilities.method_58694(type);
			if (elements == null) return List.of();

			List<TrimEntityAbilityRunner<?>> runners = new ArrayList<>();
			for (ConditionalElement<A> element : elements) {
				runners.add(new TrimEntityAbilityRunner<>(element.element(), element::matches, matcher));
			}
			return runners;
		});
	}

	public <A extends TrimValueAbility> List<TrimValueAbilityRunner<?>> getValueAbilityRunners(class_9331<List<ConditionalElement<A>>> type) {
		return valueAbilityRunners.computeIfAbsent(type, k -> {
			List<ConditionalElement<A>> elements = this.abilities.method_58694(type);
			if (elements == null) return List.of();

			List<TrimValueAbilityRunner<?>> runners = new ArrayList<>();
			for (ConditionalElement<A> element : elements) {
				runners.add(new TrimValueAbilityRunner<>(element.element(), element::matches, matcher));
			}
			return runners;
		});
	}

	public <A extends TrimToggleAbility> List<TrimToggleAbilityRunner<?>> getToggleAbilityRunners(class_9331<List<ConditionalElement<A>>> type) {
		return toggleAbilityRunners.computeIfAbsent(type, k -> {
			List<ConditionalElement<A>> elements = this.abilities.method_58694(type);
			if (elements == null) return List.of();

			List<TrimToggleAbilityRunner<?>> runners = new ArrayList<>();
			for (ConditionalElement<A> element : elements) {
				runners.add(new TrimToggleAbilityRunner<>(element.element(), element::matches, matcher));
			}
			return runners;
		});
	}

	public <A extends TrimElement> List<ConditionalElementMatcher<?>> getAbilityElements(class_9331<List<ConditionalElement<A>>> type) {
		return elementMatchers.computeIfAbsent(type, k -> getElements(type, abilities));
	}

	public <A extends TrimElement> List<ConditionalElementMatcher<?>> getItemPropertyElements(class_9331<List<ConditionalElement<A>>> type) {
		return elementMatchers.computeIfAbsent(type, k -> getElements(type, itemProperties));
	}

	private <A extends TrimElement> @NotNull List<ConditionalElementMatcher<?>> getElements(class_9331<List<ConditionalElement<A>>> type, class_9323 elementMap) {
		List<ConditionalElement<A>> elements = elementMap.method_58694(type);
		if (elements == null) return List.of();

		List<ConditionalElementMatcher<?>> matchers = new ArrayList<>();
		for (ConditionalElement<A> element : elements) {
			matchers.add(new ConditionalElementMatcher<>(matcher, element));
		}
		return matchers;
	}

	public Matcher matcher() {
		return matcher;
	}

	private class_9323 abilities() {
		return abilities;
	}

	private class_9323 itemProperties() {
		return itemProperties;
	}

	@Override
	public String toString() {
		return "TrimProperty{matcher=%s, abilities=%s, itemProperties=%s}".formatted(matcher, abilities, itemProperties);
	}

	public static Builder builder(Matcher matcher) {
		return new Builder(matcher);
	}

	public static class Builder {
		private final Map<class_9331<?>, List<?>> abilityLists = new HashMap<>();
		private final class_9323.class_9324 abilityMapBuilder = class_9323.method_57827();

		private final Map<class_9331<?>, List<?>> itemPropertyLists = new HashMap<>();
		private final class_9323.class_9324 itemPropertiesMapBuilder = class_9323.method_57827();

		private final Matcher matcher;

		public Builder(Matcher matcher) {
			this.matcher = matcher;
		}

		public <A extends TrimElement> Builder ability(class_9331<List<ConditionalElement<A>>> type, A ability) {
			getAbilityList(type).add(new ConditionalElement<>(ability, Optional.empty()));
			return this;
		}

		public <A extends TrimElement> Builder ability(class_9331<List<ConditionalElement<A>>> type, A ability, class_5341.class_210 requirements) {
			getAbilityList(type).add(new ConditionalElement<>(ability, Optional.of(requirements.build())));
			return this;
		}

		public <A extends TrimElement> Builder itemProperty(class_9331<List<ConditionalElement<A>>> type, A itemProperty) {
			getItemProperties(type).add(new ConditionalElement<>(itemProperty, Optional.empty()));
			return this;
		}

		public <A extends TrimElement> Builder itemProperty(class_9331<List<ConditionalElement<A>>> type, A itemProperty, class_5341.class_210 requirements) {
			getItemProperties(type).add(new ConditionalElement<>(itemProperty, Optional.of(requirements.build())));
			return this;
		}

		@SuppressWarnings("unchecked")
		private <A> List<A> getAbilityList(class_9331<List<A>> type) {
			return (List<A>) abilityLists.computeIfAbsent(
					type, k -> {
						List<A> list = new ArrayList<>();
						abilityMapBuilder.method_57840(type, list);
						return list;
					}
			);
		}

		@SuppressWarnings("unchecked")
		private <A> List<A> getItemProperties(class_9331<List<A>> type) {
			return (List<A>) itemPropertyLists.computeIfAbsent(
					type, k -> {
						List<A> list = new ArrayList<>();
						itemPropertiesMapBuilder.method_57840(type, list);
						return list;
					}
			);
		}

		public TrimProperty build() {
			return new TrimProperty(matcher, abilityMapBuilder.method_57838(), itemPropertiesMapBuilder.method_57838());
		}
	}
}
