package com.bawnorton.bettertrims.property.ability.runner;

import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.context.ContextChecker;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_47;

public final class TrimToggleAbilityRunner<T extends TrimToggleAbility> implements ContextChecker {
	private final T ability;
	private final Predicate<class_47> conditionChecker;
	private final Matcher matcher;

	private final Set<UUID> active = new HashSet<>();

	public TrimToggleAbilityRunner(T ability, Predicate<class_47> conditionChecker, Matcher matcher) {
		this.ability = ability;
		this.conditionChecker = conditionChecker;
		this.matcher = matcher;
	}

	public void runStart(class_3218 level, class_1309 wearer) {
		Map<class_1304, class_1799> matchingStacks = matcher.getMatchingStacks(wearer);
		TrimmedItems items = TrimmedItems.of(matchingStacks, wearer);
		if (items.size() >= matcher.minCount() && checkRequirement(TrimContexts.equipment(level, items))) {
			ability.start(level, wearer, items);
			active.add(wearer.method_5667());
		}
	}

	public void runStop(class_3218 level, class_1309 wearer, class_1799 leftStack, class_1304 leftSlot) {
		Map<class_1304, class_1799> matchingStacks = matcher.getMatchingStacks(wearer);
		int count = matchingStacks.size();
		boolean wasContributing = matcher.matches(wearer, leftStack, leftSlot);
		int contributingCount = wasContributing ? count + 1 : count;
		if (contributingCount <= 0) return;

		TrimmedItems items = TrimmedItems.of(matchingStacks, wearer);
		ability.stop(level, wearer, items);
		active.remove(wearer.method_5667());
		if (count >= matcher.minCount() && checkRequirement(TrimContexts.equipment(level, items))) {
			ability.start(level, wearer, items);
			active.add(wearer.method_5667());
		}
	}

	public void update(class_3218 level, class_1309 wearer) {
		Map<class_1304, class_1799> matchingStacks = matcher.getMatchingStacks(wearer);
		TrimmedItems items = TrimmedItems.of(matchingStacks, wearer);
		boolean passes = matchingStacks.size() >= matcher.minCount() && checkRequirement(TrimContexts.equipment(level, items));
		boolean active = this.active.contains(wearer.method_5667());
		if (active && !passes) {
			ability.stop(level, wearer, items);
			this.active.remove(wearer.method_5667());
		} else if (!active && passes) {
			ability.start(level, wearer, items);
			this.active.add(wearer.method_5667());
		}
	}

	@Override
	public Predicate<class_47> conditionChecker() {
		return conditionChecker;
	}
}
