package com.bawnorton.bettertrims.property.element;

import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.context.ContextChecker;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_47;

public class ElementMatcher<T extends TrimElement> implements ContextChecker {
	private final Matcher matcher;
	private final T element;

	public ElementMatcher(Matcher matcher, T element) {
		this.matcher = matcher;
		this.element = element;
	}

	public T getElement() {
		return element;
	}

	@Override
	public Predicate<class_47> conditionChecker() {
		return Predicates.alwaysTrue();
	}

	public boolean matches(class_1799 stack, class_47 context) {
		return matcher.matches(stack) && checkRequirement(context);
	}

	public boolean matches(class_1309 wearer, class_47 context) {
		return matcher.getMatchingStacks(wearer).size() >= matcher.minCount() && checkRequirement(context);
	}

	public TrimmedItems getMatchingItems(class_1309 wearer) {
		Map<class_1304, class_1799> matchingStacks = matcher.getMatchingStacks(wearer);
		return TrimmedItems.of(matchingStacks, wearer);
	}
}
