/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.toggle;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public record AttributeAbility(class_2960 id, class_6880<class_1320> attribute, CountBasedValue value, class_1322.class_1323 operation) implements TrimToggleAbility
{
    public static final MapCodec<AttributeAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(AttributeAbility::id), (App)class_1320.field_51575.fieldOf("attribute").forGetter(AttributeAbility::attribute), (App)CountBasedValue.CODEC.fieldOf("value").forGetter(AttributeAbility::value), (App)class_1322.class_1323.field_45742.fieldOf("operation").forGetter(AttributeAbility::operation)).apply((Applicative)instance, AttributeAbility::new));

    private Multimap<class_6880<class_1320>, class_1322> makeAttributeMap(int count) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put(this.attribute, (Object)this.getAttributeModifier(count));
        return multimap;
    }

    private class_1322 getAttributeModifier(int count) {
        return new class_1322(this.id, (double)this.value.calculate(count), this.operation);
    }

    @Override
    public void start(class_3218 level, class_1309 wearer, TrimmedItems items) {
        wearer.method_6127().method_59932(this.makeAttributeMap(items.size()));
    }

    @Override
    public void stop(class_3218 level, class_1309 wearer, TrimmedItems items) {
        wearer.method_6127().method_59935(this.makeAttributeMap(items.size()));
    }

    @Override
    public boolean usesCount() {
        return true;
    }

    @Override
    public MapCodec<? extends TrimToggleAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<AttributeAbility> {
        @Override
        @Nullable
        public class_5684 getTooltip(class_638 level, AttributeAbility element, boolean includeCount) {
            boolean distinct = element.value().getValueComponents(4, includeCount).size() == 1;
            ArrayList modifiers = new ArrayList();
            for (int i = 1; i <= 4; ++i) {
                int count = i;
                class_9285.class_11193.method_70729().method_70731(component -> {
                    if (includeCount && !distinct) {
                        component = Styler.trim(class_2561.method_43470((String)"[%d]".formatted(count))).method_27693(": ").method_10852(component);
                    }
                    modifiers.add(component);
                }, (class_1657)class_310.method_1551().field_1724, element.attribute(), element.getAttributeModifier(i));
            }
            return CompositeContainerComponent.builder().cycle(builder -> modifiers.forEach(builder::textComponent)).build();
        }
    }
}

