package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import net.minecraft.advancements.critereon.*;
import net.minecraft.advancements.critereon.ItemDamagePredicate;
import net.minecraft.client.multiplayer.ClientLevel;

public final class DamagePredicatePartialAdder implements PartialAdder</*$ damage_predicate >>*/ ItemDamagePredicate > {
	@Override
	public void addToBuilder(ClientLevel level, /*$ damage_predicate >>*/ ItemDamagePredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		MinMaxBounds.Ints damage = predicate.damage();
		MinMaxBounds.Ints durability = predicate.durability();

		builder.space();
		boolean useAnd = false;
		if (!damage.isAny()) {
			PredicateTooltip.addMinMaxToBuilder(key("damage.max_damage"), false, damage, state, builder);
			useAnd = true;
		}
		if (!durability.isAny()) {
			PredicateTooltip.addMinMaxToBuilder(key("damage.durability"), useAnd, durability, state, builder);
		}
	}
}
