package com.bawnorton.bettertrims.property.context;

import com.bawnorton.bettertrims.BetterTrims;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

import java.util.function.Consumer;

public final class TrimContextParamSets {
	private static final BiMap<ResourceLocation, LootContextParamSet> REGISTRY = HashBiMap.create();

	public static final LootContextParamSet TRIM_DAMAGE = register(
			"trim_damage",
			builder -> builder.required(LootContextParams.THIS_ENTITY)
					.required(TrimContextParams.ITEMS)
					.required(LootContextParams.ORIGIN)
					.required(LootContextParams.DAMAGE_SOURCE)
					.optional(LootContextParams.DIRECT_ATTACKING_ENTITY)
					.optional(LootContextParams.ATTACKING_ENTITY)
					.optional(LootContextParams.TOOL) // damaging tool
	);

	public static final LootContextParamSet HIT_BLOCK_WITH_HELD_ITEM = register(
			"hit_block_with_held_item",
			builder -> builder.required(LootContextParams.THIS_ENTITY)
					.required(LootContextParams.ORIGIN)
					.required(TrimContextParams.ITEMS)
					.required(LootContextParams.BLOCK_STATE)
					.required(LootContextParams.TOOL)
	);

	public static final LootContextParamSet TRIM_EQUIPMENT = register(
			"trim_equipment",
			builder -> builder.required(LootContextParams.THIS_ENTITY)
					.required(LootContextParams.ORIGIN)
					.required(TrimContextParams.ITEMS)
					.optional(LootContextParams.TOOL)
	);

	public static final LootContextParamSet TRIM_ITEM_DAMAGE = register(
			"trim_item_damage",
			builder -> builder.required(LootContextParams.TOOL)
					.required(LootContextParams.DAMAGE_SOURCE)
					.optional(LootContextParams.THIS_ENTITY)
					.optional(LootContextParams.ORIGIN)
					.optional(LootContextParams.DIRECT_ATTACKING_ENTITY)
					.optional(LootContextParams.ATTACKING_ENTITY)
	);

	public static final LootContextParamSet TRIM_ENTITY = register(
			"trim_entity",
			builder -> builder.required(LootContextParams.THIS_ENTITY)
					.required(TrimContextParams.ITEMS)
					.required(LootContextParams.ORIGIN)
	);

	private static LootContextParamSet register(String name, Consumer<LootContextParamSet.Builder> ctor) {
		LootContextParamSet.Builder builder = new LootContextParamSet.Builder();
		ctor.accept(builder);
		LootContextParamSet contextKeySet = builder.build();
		ResourceLocation resourceLocation = BetterTrims.rl(name);
		if (REGISTRY.put(resourceLocation, contextKeySet) != null) {
			throw new IllegalStateException("Trim parameter set " + resourceLocation + " is already registered");
		} else {
			return contextKeySet;
		}
	}
}
