/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.tooltip.ExpandedTooltipPositioner;
import com.bawnorton.bettertrims.client.tooltip.TrimPropertiesTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.version.VGuiGraphics;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class AbilityTooltipRenderer {
    private static final ThreadLocal<ItemStack> STACK_CAPTURE = ThreadLocal.withInitial(() -> ItemStack.EMPTY);
    private static final Map<ArmorTrim, TrimPropertiesTooltip> tooltips = new HashMap<ArmorTrim, TrimPropertiesTooltip>();
    private static TrimPropertiesTooltip currentTooltip = null;
    private static final LongSet EXCEPTION_HASHES = new LongArraySet();

    public static void render(GuiGraphics graphics, ItemStack stack, Font font, Rect2i tooltipBounds, int mouseX, @Nullable ResourceLocation background) {
        if (stack.isEmpty()) {
            return;
        }
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        if (!AbilityTooltipRenderer.hasProperties(level, trim)) {
            return;
        }
        boolean hasAltDown = Screen.hasAltDown();
        if (!hasAltDown && !BetterTrims.debug) {
            boolean shouldFlip = mouseX + tooltipBounds.getWidth() + 38 > graphics.guiWidth();
            AbilityTooltipRenderer.renderPrompt(graphics, font, tooltipBounds, shouldFlip, background);
            return;
        }
        boolean shouldFlip = mouseX > tooltipBounds.getX();
        try {
            AbilityTooltipRenderer.renderProperties(graphics, level, font, trim, tooltipBounds, shouldFlip, background);
        }
        catch (Exception e) {
            long hash = e.getClass().getName().hashCode();
            hash ^= e.getMessage() != null ? (long)e.getMessage().hashCode() : 0L;
            for (StackTraceElement element : e.getStackTrace()) {
                hash ^= 31L * hash * (long)element.getClassName().hashCode();
                hash ^= 31L * hash * (long)element.getMethodName().hashCode();
                hash ^= 31L * hash * (long)element.getLineNumber();
            }
            if (EXCEPTION_HASHES.add(hash)) {
                BetterTrims.LOGGER.error("Failed to render trim properties tooltip for trim {} on item {}", new Object[]{trim, stack, e});
            }
            AbilityTooltipRenderer.renderError(graphics, font, tooltipBounds, shouldFlip, background);
        }
    }

    private static boolean hasProperties(ClientLevel level, ArmorTrim trim) {
        for (TrimProperty property : TrimProperties.getProperties((Level)level)) {
            if (!property.matcher().matches(trim)) continue;
            return true;
        }
        return false;
    }

    private static void renderProperties(GuiGraphics graphics, ClientLevel level, Font font, ArmorTrim trim, Rect2i tooltipBounds, boolean horizontallyFlipped, ResourceLocation background) {
        currentTooltip = tooltips.computeIfAbsent(trim, a -> {
            HashMap<Matcher, List<TrimProperty>> matchedProperties = new HashMap<Matcher, List<TrimProperty>>();
            for (TrimProperty property : TrimProperties.getProperties((Level)level)) {
                Matcher matcher = property.matcher();
                if (!matcher.matches(trim)) continue;
                matchedProperties.computeIfAbsent(matcher, m -> new ArrayList()).add(property);
            }
            TrimPropertiesTooltip tooltip = new TrimPropertiesTooltip(matchedProperties);
            tooltip.generatePages(level, font);
            return tooltip;
        });
        currentTooltip.render(graphics, level, font, tooltipBounds, horizontallyFlipped, background);
    }

    private static void renderPrompt(GuiGraphics graphics, Font font, Rect2i tooltipBounds, boolean horizontallyFlipped, @Nullable ResourceLocation background) {
        int promptWidth = 8;
        int promptHeight = 8;
        int xOffset = tooltipBounds.getX() + (horizontallyFlipped ? -promptWidth - 10 : tooltipBounds.getWidth() + 10);
        int yOffset = tooltipBounds.getY();
        if (Minecraft.ON_OSX) {
            graphics.pose().pushPose();
            graphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)xOffset, (int)yOffset, (int)promptWidth, (int)promptHeight, (int)400));
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
            int colour = ChatFormatting.GOLD.getColor();
            float[] existing = new float[4];
            for (int i = 0; i < 4; ++i) {
                existing[i] = RenderSystem.getShaderColor()[i];
            }
            RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)colour) / 255.0f), (float)((float)FastColor.ARGB32.green((int)colour) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)colour) / 255.0f), (float)1.0f);
            graphics.blitSprite(BetterTrims.rl("text/alt"), xOffset, yOffset, promptWidth, promptHeight);
            RenderSystem.setShaderColor((float)existing[0], (float)existing[1], (float)existing[2], (float)existing[3]);
            graphics.pose().popPose();
        } else {
            VGuiGraphics.renderTooltip(graphics, font, List.of(new ClientTextTooltip(Component.literal((String)"Alt").withStyle(Styler::trim).getVisualOrderText())), xOffset - 10, yOffset, new ExpandedTooltipPositioner(tooltipBounds.getWidth()), background);
        }
    }

    private static void renderError(GuiGraphics graphics, Font font, Rect2i tooltipBounds, boolean shouldFlip, @Nullable ResourceLocation background) {
        List<ClientTextTooltip> errorComponents = List.of(new ClientTextTooltip(Component.translatable((String)"bettertrims.tooltip.properties.error").withStyle(ChatFormatting.RED).getVisualOrderText()));
        int offsetX = tooltipBounds.getX() + tooltipBounds.getWidth() + (shouldFlip ? 14 : 0);
        int offsetY = tooltipBounds.getY();
        VGuiGraphics.renderTooltip(graphics, font, errorComponents, offsetX, offsetY, new ExpandedTooltipPositioner(tooltipBounds.getWidth()), background);
    }

    public static boolean mouseScrolled(double scrollY) {
        if (currentTooltip == null) {
            return false;
        }
        return currentTooltip.mouseScrolled(scrollY);
    }

    public static void clearRendering() {
        currentTooltip = null;
    }

    public static void setStack(ItemStack stack) {
        STACK_CAPTURE.set(stack);
    }

    public static ItemStack getStack() {
        return STACK_CAPTURE.get();
    }

    public static void clearStack() {
        STACK_CAPTURE.remove();
    }
}

