/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public abstract class CompositeBuilder<T> {
    private static final ClientTooltipComponent SPACE = new ClientTextTooltip(CommonComponents.SPACE.getVisualOrderText());
    protected final List<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();

    public List<ClientTooltipComponent> peek() {
        return this.components.stream().toList();
    }

    public CompositeBuilder<T> component(ClientTooltipComponent component) {
        this.components.add(component);
        return this;
    }

    public CompositeBuilder<T> textComponent(Component component) {
        return this.component((ClientTooltipComponent)new ClientTextTooltip(component.getVisualOrderText()));
    }

    public CompositeBuilder<T> translate(String key, Object ... args) {
        return this.textComponent((Component)Component.translatable((String)key, (Object[])args));
    }

    public CompositeBuilder<T> translate(String key, UnaryOperator<Style> styler, Object ... args) {
        return this.textComponent((Component)Component.translatable((String)key, (Object[])args).withStyle(styler));
    }

    public CompositeBuilder<T> literal(String text) {
        return this.textComponent((Component)Component.literal((String)text));
    }

    public CompositeBuilder<T> literal(String text, UnaryOperator<Style> styler) {
        return this.textComponent((Component)Component.literal((String)text).withStyle(styler));
    }

    public CompositeBuilder<T> space() {
        return this.component(SPACE);
    }

    public abstract T build();
}

