/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.networking;

import com.bawnorton.bettertrims.mixin.accessor.SmithingTrimRecipeAccessor;
import com.bawnorton.bettertrims.networking.packet.TrimPatternSourcePayload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber
public class Networking {
    private static final Map<Holder<TrimPattern>, HolderSet<Item>> patternProviders = new HashMap<Holder<TrimPattern>, HolderSet<Item>>();

    public static void init() {
    }

    @SubscribeEvent
    public static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(TrimPatternSourcePayload.TYPE, TrimPatternSourcePayload.CODEC, TrimPatternSourcePayload::handle);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Networking.send(player2, new TrimPatternSourcePayload(patternProviders));
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        Networking.updatePatternProviders(event.getServer());
    }

    public static <T extends CustomPacketPayload> void send(ServerPlayer player, T payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void updatePatternProviders(MinecraftServer server) {
        RecipeManager recipeManager = server.getRecipeManager();
        patternProviders.clear();
        for (RecipeHolder holder : recipeManager.getRecipes()) {
            Recipe recipe = holder.value();
            if (!(recipe instanceof SmithingTrimRecipe)) continue;
            SmithingTrimRecipe recipe2 = (SmithingTrimRecipe)recipe;
            ArrayList patternItems = new ArrayList();
            SmithingTrimRecipeAccessor accessor = (SmithingTrimRecipeAccessor)recipe2;
            Ingredient templateIngredient = accessor.bettertrims$template();
            List<ItemStack> templateItems = Arrays.asList(templateIngredient.getItems());
            List patternHolders = templateItems.stream().map(stack -> TrimPatterns.getFromTemplate((HolderLookup.Provider)server.registryAccess(), (ItemStack)stack)).flatMap(Optional::stream).toList();
            Holder patternHolder = (Holder)patternHolders.getFirst();
            if (patternHolder == null) continue;
            templateItems.forEach(stack -> {
                Item item = stack.getItem();
                patternItems.add(Holder.direct((Object)item));
            });
            patternProviders.put((Holder<TrimPattern>)patternHolder, (HolderSet<Item>)HolderSet.direct(patternItems));
        }
    }
}

