package com.bawnorton.bettertrims.property;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.data.BetterTrimsDimensionTypeTags;
import com.bawnorton.bettertrims.data.BetterTrimsEntityTypeTags;
import com.bawnorton.bettertrims.data.TrimMaterialTags;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ApplyMobEffectAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.PlaySoundAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SpawnParticlesAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SummonEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.DamageImmunityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.AttributeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.ToggleMobEffectAbility;
import com.bawnorton.bettertrims.property.condition.DimensionCheck;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.property.item.type.DamageImmunityItemProperty;
import com.bawnorton.bettertrims.registry.BetterTrimsAttributes;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import net.minecraft.advancements.critereon.*;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.component.predicates.TrimPredicate;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Optional;
//? if >=1.21.8 {
import net.minecraft.core.component.predicates.DataComponentPredicates;
//?}

public interface TrimProperties {
	ResourceKey<TrimProperty> CONDUCTIVE = key("conductive");
	ResourceKey<TrimProperty> CHARGED = key("charged");
	ResourceKey<TrimProperty> FIREPROOF = key("fireproof");
	ResourceKey<TrimProperty> IMPROVED_TRADING = key("improved_trading");
	ResourceKey<TrimProperty> INCREASE_EXPERIENCE_GAIN = key("increase_experience_gain");
	ResourceKey<TrimProperty> INCREASE_MINING_SPEED = key("increase_mining_speed");
	ResourceKey<TrimProperty> INCREASE_MOVEMENT_SPEED = key("increase_movement_speed");
	ResourceKey<TrimProperty> LUNAR_BONUSES = key("lunar_bonuses");
	ResourceKey<TrimProperty> TOUGHER = key("tougher");
	ResourceKey<TrimProperty> RESILIENT = key("resilient");
	ResourceKey<TrimProperty> RESONANT = key("resonant");
	ResourceKey<TrimProperty> SHADOWY = key("shadowy");
	ResourceKey<TrimProperty> SOLAR_BONUSES = key("solar_bonuses");
	ResourceKey<TrimProperty> WEARING_GOLD = key("wearing_gold");

	ResourceKey<TrimProperty> BOLT = key("bolt");
	ResourceKey<TrimProperty> COAST = key("coast");
	ResourceKey<TrimProperty> DUNE = key("dune");
	ResourceKey<TrimProperty> EYE = key("eye");
	ResourceKey<TrimProperty> FLOW = key("flow");
	ResourceKey<TrimProperty> HOST = key("host");
	ResourceKey<TrimProperty> RAISER = key("raiser");
	ResourceKey<TrimProperty> RIB = key("rib");
	ResourceKey<TrimProperty> SENTRY = key("sentry");
	ResourceKey<TrimProperty> SHAPER = key("shaper");
	ResourceKey<TrimProperty> SILENCE = key("silence");
	ResourceKey<TrimProperty> SNOUT = key("snout");
	ResourceKey<TrimProperty> SPIRE = key("spire");
	ResourceKey<TrimProperty> TIDE = key("tide");
	ResourceKey<TrimProperty> VEX = key("vex");
	ResourceKey<TrimProperty> WARD = key("ward");
	ResourceKey<TrimProperty> WAYFINDER = key("wayfinder");
	ResourceKey<TrimProperty> WILD = key("wild");

	static void bootstrap(BootstrapContext<TrimProperty> context) {
		HolderGetter<TrimMaterial> materialGetter = context.lookup(Registries.TRIM_MATERIAL);
		HolderGetter<EntityType<?>> entityTypeGetter = context.lookup(Registries.ENTITY_TYPE);
		HolderGetter<Enchantment> enchantmentGetter = context.lookup(Registries.ENCHANTMENT);
		HolderGetter<DimensionType> dimensionGetter = context.lookup(Registries.DIMENSION_TYPE);
		HolderGetter<SoundEvent> soundEventGetter = context.lookup(Registries.SOUND_EVENT);
		register(
				context, SHADOWY, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.RESIN)).ability(
						TrimAbilityComponents.TICK,
						new SpawnParticlesAbility(
								ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER,
								SpawnParticlesEffect.inBoundingBox(),
								SpawnParticlesEffect.inBoundingBox(),
								SpawnParticlesEffect.movementScaled(-0.2F),
								SpawnParticlesEffect.fixedVelocity(ConstantFloat.of(0.1F)),
								ConstantFloat.of(0.5f)
						),
						LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.THIS,
								EntityPredicate.Builder.entity().moving(MovementPredicate.speed(MinMaxBounds.Doubles.atLeast(0.1)))
						)
				).ability(
						TrimAbilityComponents.TICK,
						new SpawnParticlesAbility(
								ParticleTypes.ASH,
								SpawnParticlesEffect.inBoundingBox(),
								SpawnParticlesEffect.inBoundingBox(),
								SpawnParticlesEffect.fixedVelocity(ConstantFloat.of(0)),
								SpawnParticlesEffect.fixedVelocity(ConstantFloat.of(0)),
								ConstantFloat.of(0)
						),
						LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.THIS,
								EntityPredicate.Builder.entity().moving(MovementPredicate.speed(MinMaxBounds.Doubles.atMost(0.1)))
						)
				).ability(
						TrimAbilityComponents.EQUIPPED,
						new AttributeAbility(
								BetterTrims.rl("trim_true_invisibility"),
								BetterTrimsAttributes.TRUE_INVISIBILITY,
								CountBasedValue.constant(1),
								AttributeModifier.Operation.ADD_VALUE
						),
						LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.THIS,
								EntityPredicate.Builder.entity().moving(MovementPredicate.speed(MinMaxBounds.Doubles.atMost(0.1)))
						)
				).ability(
						TrimAbilityComponents.DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.linear(1.25f, 0.25f)),
						LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.THIS,
								EntityPredicate.Builder.entity().moving(MovementPredicate.speed(MinMaxBounds.Doubles.atMost(0.1)))
						)
				).build()
		);
		register(
				context,
				WEARING_GOLD,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.GOLD)).ability(TrimAbilityComponents.PIGLIN_SAFE, PiglinSafeAbility.INSTANCE).build()
		);
		register(
				context, INCREASE_MINING_SPEED, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.IRON))
						.ability(
								TrimAbilityComponents.EQUIPPED,
								new AttributeAbility(BetterTrims.rl("trim_mining_speed"), Attributes.MINING_EFFICIENCY, CountBasedValue.countSquared(1), AttributeModifier.Operation.ADD_VALUE)
						)
						.ability(
								TrimAbilityComponents.EQUIPPED,
								new ToggleMobEffectAbility(MobEffects.HASTE, CountBasedValue.constant(1)),
								wearingFullSet(materialGetter, TrimMaterialTags.IRON)
						)
						.build()
		);
		register(
				context, RESILIENT, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.DIAMOND)).ability(
						TrimAbilityComponents.INCOMING_DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.linear(0.95f, -0.05f)),
						DamageSourceCondition.hasDamageSource(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_RESISTANCE)))
				).ability(
						TrimAbilityComponents.ITEM_DAMAGE,
						TrimValueAbility.removeBinomial(CountBasedValue.fraction(CountBasedValue.linear(1), CountBasedValue.linear(4, 1))),
						MatchTool.toolMatches(itemMaterialPredicate(materialGetter, TrimMaterialTags.DIAMOND))
				).build()
		);
		register(
				context, RESONANT, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.AMETHYST)).ability(
						TrimAbilityComponents.POST_ATTACK,
						new PlaySoundAbility(
								Holder.direct(SoundEvents.AMETHYST_BLOCK_RESONATE),
								UniformFloat.of(0.8f, 1.2f),
								UniformFloat.of(0.8f, 1.2f)
						)
				).ability(
						TrimAbilityComponents.HIT_BLOCK,
						new PlaySoundAbility(
								Holder.direct(SoundEvents.AMETHYST_BLOCK_RESONATE),
								UniformFloat.of(0.8f, 1.2f),
								UniformFloat.of(0.8f, 1.2f)
						)
				).ability(
						TrimAbilityComponents.INCOMING_DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.clamped(CountBasedValue.linear(0.75f, -0.25f), 0, 1f)),
						LootItemRandomChanceCondition.randomChance(0.05f)
				).ability(
						TrimAbilityComponents.DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.linear(5)),
						LootItemRandomChanceCondition.randomChance(0.05f)
				).build()
		);
		register(
				context, TOUGHER, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.NETHERITE)).ability(
						TrimAbilityComponents.EQUIPPED, AllOf.toggleAbilities(
								new AttributeAbility(BetterTrims.rl("trim_armour_toughness"), Attributes.ARMOR_TOUGHNESS, CountBasedValue.linear(1), AttributeModifier.Operation.ADD_VALUE),
								new AttributeAbility(BetterTrims.rl("trim_armour"), Attributes.ARMOR, CountBasedValue.linear(2), AttributeModifier.Operation.ADD_VALUE)
						)
				).ability(
						TrimAbilityComponents.ITEM_DAMAGE,
						TrimValueAbility.removeBinomial(CountBasedValue.fraction(CountBasedValue.linear(1), CountBasedValue.linear(2, 1))),
						MatchTool.toolMatches(itemMaterialPredicate(materialGetter, TrimMaterialTags.NETHERITE))
				).build()
		);
		register(
				context,
				FIREPROOF,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.NETHERITE))
						.ability(TrimAbilityComponents.EQUIPPED, new ToggleMobEffectAbility(MobEffects.FIRE_RESISTANCE, CountBasedValue.constant(0)))
						.itemProperty(
								TrimItemPropertyComponents.DAMAGE_IMMUNITY,
								DamageImmunityItemProperty.INSTANCE,
								DamageSourceCondition.hasDamageSource(DamageSourcePredicate.Builder.damageType()
										.tag(TagPredicate.is(DamageTypeTags.IS_FIRE))
										.tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))
						)
						.build()
		);
		register(
				context,
				INCREASE_EXPERIENCE_GAIN,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.QUARTZ))
						.ability(TrimAbilityComponents.EXPERIENCE_GAINED, TrimValueAbility.multiply(CountBasedValue.linear(1.25f, 0.25f)))
						.build()
		);
		register(
				context, INCREASE_MOVEMENT_SPEED, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.REDSTONE)).ability(
						TrimAbilityComponents.EQUIPPED,
						new AttributeAbility(
								BetterTrims.rl("trim_movement_speed"),
								Attributes.MOVEMENT_SPEED,
								CountBasedValue.linear(0.12f),
								AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL
						)
				).build()
		);
		register(
				context, CONDUCTIVE, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.COPPER)).ability(
						TrimAbilityComponents.DAMAGE_IMMUNITY,
						DamageImmunityAbility.INSTANCE,
						DamageSourceCondition.hasDamageSource(DamageSourcePredicate.Builder.damageType()
								.tag(TagPredicate.is(DamageTypeTags.IS_LIGHTNING))
								.tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))
				).itemProperty(
						TrimItemPropertyComponents.DAMAGE_IMMUNITY,
						DamageImmunityItemProperty.INSTANCE,
						DamageSourceCondition.hasDamageSource(DamageSourcePredicate.Builder.damageType()
								.tag(TagPredicate.is(DamageTypeTags.IS_LIGHTNING))
								.tag(TagPredicate.isNot(DamageTypeTags.BYPASSES_INVULNERABILITY)))
				).build()
		);
		register(
				context, CHARGED, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.COPPER)).ability(
						TrimAbilityComponents.PROJECTILE_TICK, new SpawnParticlesAbility(
								ParticleTypes.ELECTRIC_SPARK,
								SpawnParticlesEffect.offsetFromEntityPosition(0),
								SpawnParticlesEffect.offsetFromEntityPosition(0),
								SpawnParticlesEffect.movementScaled(-0.5f),
								SpawnParticlesEffect.movementScaled(-0.5f),
								ConstantFloat.of(1)
						), LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.THIS,
								EntityPredicate.Builder.entity().entityType(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
						)
				).ability(
						TrimAbilityComponents.DAMAGE,
						TrimValueAbility.add(CountBasedValue.linear(0.5F)),
						LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.DIRECT_ATTACKER,
								EntityPredicate.Builder.entity().entityType(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
						)
				).ability(
						TrimAbilityComponents.POST_ATTACK,
						AllOf.entityAbilities(
								new SummonEntityAbility(EntityType.LIGHTNING_BOLT),
								new PlaySoundAbility(SoundEvents.TRIDENT_THUNDER, ConstantFloat.of(5F), ConstantFloat.of(1F))
						),
						AllOfCondition.allOf(
								WeatherCheck.weather().setThundering(true),
								LootItemEntityPropertyCondition.hasProperties(
										LootContext.EntityTarget.THIS,
										EntityPredicate.Builder.entity().located(LocationPredicate.Builder.location().setCanSeeSky(true))
								),
								LootItemEntityPropertyCondition.hasProperties(
										LootContext.EntityTarget.DIRECT_ATTACKER,
										EntityPredicate.Builder.entity().entityType(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
								),
								InvertedLootItemCondition.invert(MatchTool.toolMatches(itemEnchantedPredicate(enchantmentGetter, Enchantments.CHANNELING)))
						)
				).ability(
						TrimAbilityComponents.HIT_BLOCK,
						AllOf.entityAbilities(
								new SummonEntityAbility(EntityType.LIGHTNING_BOLT),
								new PlaySoundAbility(SoundEvents.TRIDENT_THUNDER, ConstantFloat.of(5.0F), ConstantFloat.of(1.0F))
						),
						AllOfCondition.allOf(
								WeatherCheck.weather().setThundering(true),
								LootItemEntityPropertyCondition.hasProperties(
										LootContext.EntityTarget.THIS,
										EntityPredicate.Builder.entity().entityType(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
								),
								LootItemBlockStatePropertyCondition.hasBlockStateProperties(Blocks.LIGHTNING_ROD),
								InvertedLootItemCondition.invert(MatchTool.toolMatches(itemEnchantedPredicate(enchantmentGetter, Enchantments.CHANNELING)))
						)
				).build()
		);
		register(
				context, SOLAR_BONUSES, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.GOLD)).ability(
						TrimAbilityComponents.EQUIPPED,
						AllOf.toggleAbilities(
								new AttributeAbility(
										BetterTrims.rl("trim_solar_bonus_attack_damage"),
										Attributes.ATTACK_DAMAGE,
										CountBasedValue.linear(1),
										AttributeModifier.Operation.ADD_VALUE
								),
								new AttributeAbility(
										BetterTrims.rl("trim_solar_bonus_movement_speed"),
										Attributes.MOVEMENT_SPEED,
										CountBasedValue.linear(0.07f),
										AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL
								),
								new AttributeAbility(BetterTrims.rl("trim_solar_bonus_armour"), Attributes.ARMOR, CountBasedValue.linear(1), AttributeModifier.Operation.ADD_VALUE),
								new AttributeAbility(
										BetterTrims.rl("trim_solar_bonus_attack_speed"),
										Attributes.ATTACK_SPEED,
										CountBasedValue.linear(0.5f),
										AttributeModifier.Operation.ADD_VALUE
								)
						),
						AllOfCondition.allOf(
								TimeCheck.time(IntRange.upperBound(13000)).setPeriod(24000),
								DimensionCheck.of(dimensionGetter.getOrThrow(BetterTrimsDimensionTypeTags.HAS_SUN))
						)
				).build()
		);
		register(
				context, LUNAR_BONUSES, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.SILVER)).ability(
						TrimAbilityComponents.EQUIPPED,
						AllOf.toggleAbilities(
								new AttributeAbility(
										BetterTrims.rl("trim_lunar_bonus_attack_damage"),
										Attributes.ATTACK_DAMAGE,
										CountBasedValue.linear(1),
										AttributeModifier.Operation.ADD_VALUE
								),
								new AttributeAbility(
										BetterTrims.rl("trim_lunar_bonus_movement_speed"),
										Attributes.MOVEMENT_SPEED,
										CountBasedValue.linear(0.07f),
										AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL
								),
								new AttributeAbility(BetterTrims.rl("trim_lunar_bonus_armour"), Attributes.ARMOR, CountBasedValue.linear(1), AttributeModifier.Operation.ADD_VALUE),
								new AttributeAbility(
										BetterTrims.rl("trim_lunar_bonus_attack_speed"),
										Attributes.ATTACK_SPEED,
										CountBasedValue.linear(0.05f),
										AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL
								)
						),
						AllOfCondition.allOf(
								TimeCheck.time(IntRange.lowerBound(13000)).setPeriod(24000),
								DimensionCheck.of(dimensionGetter.getOrThrow(BetterTrimsDimensionTypeTags.HAS_MOON))
						)
				).ability(
						TrimAbilityComponents.EQUIPPED,
						new ToggleMobEffectAbility(MobEffects.NIGHT_VISION, CountBasedValue.constant(0)),
						wearingInSlot(materialGetter, TrimMaterialTags.SILVER, EquipmentSlot.HEAD)
				).build()
		);
		register(
				context,
				IMPROVED_TRADING,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.EMERALD))
						.ability(TrimAbilityComponents.TRADE_COST, TrimValueAbility.multiply(CountBasedValue.linear(0.9f, -0.1f)))
						.build()
		);
	}

	static void bootstrapTrimEffects(BootstrapContext<TrimProperty> context) {
		registerTrimEffect(context, BOLT, TrimPatterns.BOLT, MobEffects.DOLPHINS_GRACE);
		registerTrimEffect(context, COAST, TrimPatterns.COAST, MobEffects.WATER_BREATHING);
		registerTrimEffect(context, DUNE, TrimPatterns.DUNE, MobEffects.SPEED);
		registerTrimEffect(context, EYE, TrimPatterns.EYE, MobEffects.REGENERATION);
		registerTrimEffect(context, FLOW, TrimPatterns.FLOW, MobEffects.JUMP_BOOST);
		registerTrimEffect(context, HOST, TrimPatterns.HOST, MobEffects.GLOWING);
		registerTrimEffect(context, RAISER, TrimPatterns.RAISER, MobEffects.SATURATION);
		registerTrimEffect(context, RIB, TrimPatterns.RIB, MobEffects.HASTE);
		registerTrimEffect(context, SENTRY, TrimPatterns.SENTRY, MobEffects.RESISTANCE);
		registerTrimEffect(context, SHAPER, TrimPatterns.SHAPER, MobEffects.LUCK);
		registerTrimEffect(context, SILENCE, TrimPatterns.SILENCE, MobEffects.HEALTH_BOOST);
		registerTrimEffect(context, SNOUT, TrimPatterns.SNOUT, MobEffects.FIRE_RESISTANCE);
		registerTrimEffect(context, SPIRE, TrimPatterns.SPIRE, MobEffects.STRENGTH);
		registerTrimEffect(context, TIDE, TrimPatterns.TIDE, MobEffects.CONDUIT_POWER);
		registerTrimEffect(context, VEX, TrimPatterns.VEX, MobEffects.INVISIBILITY);
		registerTrimEffect(context, WAYFINDER, TrimPatterns.WAYFINDER, MobEffects.SLOW_FALLING);
		registerTrimEffect(context, WILD, TrimPatterns.WILD, MobEffects.HERO_OF_THE_VILLAGE);

		register(
				context,
				WARD,
				TrimProperty.builder(Matcher.forPattern(HolderSet.direct(context.lookup(Registries.TRIM_PATTERN).getOrThrow(TrimPatterns.WARD)), 2)).ability(
						TrimAbilityComponents.SECOND,
						new ApplyMobEffectAbility(
								MobEffects.ABSORPTION,
								CountBasedValue.lookup(List.of(-1F, 0F, 0F, 1F), CountBasedValue.constant(0)),
								CountBasedValue.constant(16)
						),
						LootItemEntityPropertyCondition.hasProperties(
								LootContext.EntityTarget.THIS,
								new EntityPredicate.Builder().periodicTick(300)
						)
				).build()
		);
	}

	private static void registerTrimEffect(BootstrapContext<TrimProperty> context, ResourceKey<TrimProperty> key, ResourceKey<TrimPattern> pattern, Holder<MobEffect> effect) {
		register(
				context,
				key,
				TrimProperty.builder(Matcher.forPattern(HolderSet.direct(context.lookup(Registries.TRIM_PATTERN).getOrThrow(pattern)), 2)).ability(
						TrimAbilityComponents.SECOND,
						new ApplyMobEffectAbility(effect, CountBasedValue.lookup(List.of(-1F, 0F, 0F, 1F), CountBasedValue.constant(0)), CountBasedValue.constant(9))
				).build()
		);
	}

	private static EntityTypePredicate getEntityTypePredicate(HolderGetter<EntityType<?>> entityTypeGetter, TagKey<EntityType<?>> tag) {
		//? if >=1.21.8 {
		return EntityTypePredicate.of(entityTypeGetter, tag);
		 //?} else {
		/*return EntityTypePredicate.of(tag);
		 *///?}
	}

	private static LootItemCondition.Builder wearingInSlot(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material, EquipmentSlot slot) {
		return LootItemEntityPropertyCondition.hasProperties(
				LootContext.EntityTarget.THIS,
				EntityPredicate.Builder.entity().equipment(addSlot(EntityEquipmentPredicate.Builder.equipment(), materialGetter, material, slot))
		);
	}

	private static LootItemCondition.Builder wearingFullSet(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
		return LootItemEntityPropertyCondition.hasProperties(
				LootContext.EntityTarget.THIS,
				EntityPredicate.Builder.entity().equipment(fullSetMaterialPredicate(materialGetter, material))
		);
	}

	private static EntityEquipmentPredicate.Builder fullSetMaterialPredicate(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
		EntityEquipmentPredicate.Builder builder = EntityEquipmentPredicate.Builder.equipment();
		for (EquipmentSlot slot : List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
			addSlot(builder, materialGetter, material, slot);
		}
		return builder;
	}

	private static EntityEquipmentPredicate.Builder addSlot(EntityEquipmentPredicate.Builder builder, HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material, EquipmentSlot slot) {
		switch (slot) {
			case HEAD -> builder.head(itemMaterialPredicate(materialGetter, material));
			case CHEST -> builder.chest(itemMaterialPredicate(materialGetter, material));
			case LEGS -> builder.legs(itemMaterialPredicate(materialGetter, material));
			case FEET -> builder.feet(itemMaterialPredicate(materialGetter, material));
			case BODY -> builder.body(itemMaterialPredicate(materialGetter, material));
			case MAINHAND -> builder.mainhand(itemMaterialPredicate(materialGetter, material));
			case OFFHAND -> builder.offhand(itemMaterialPredicate(materialGetter, material));
			default -> {
			}
		}
		return builder;
	}

	private static ItemPredicate.Builder itemMaterialPredicate(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
		return ItemPredicate.Builder.item()
		//? if >=1.21.8 {
				.withComponents(DataComponentMatchers.Builder.components()
						.partial(DataComponentPredicates.ARMOR_TRIM, new TrimPredicate(Optional.of(materialGetter.getOrThrow(material)), Optional.empty()))
						.build());
		//?} else {
				/*.withSubPredicate(
						ItemSubPredicates.ARMOR_TRIM,
						new ItemTrimPredicate(
								Optional.of(materialGetter.getOrThrow(material)),
								Optional.empty()
						)
				);
		*///?}
	}

	private static ItemPredicate.Builder itemEnchantedPredicate(HolderGetter<Enchantment> enchantmentGetter, ResourceKey<Enchantment> enchantment) {
		return ItemPredicate.Builder.item()
		//? if >=1.21.8 {
				.withComponents(DataComponentMatchers.Builder.components().partial(
						DataComponentPredicates.ENCHANTMENTS,
						EnchantmentsPredicate.Enchantments.enchantments(List.of(new EnchantmentPredicate(enchantmentGetter.getOrThrow(enchantment), MinMaxBounds.Ints.ANY)))
				).build());
		//?} else {
				/*.withSubPredicate(
						ItemSubPredicates.ENCHANTMENTS,
						ItemEnchantmentsPredicate.enchantments(
								List.of(
										new EnchantmentPredicate(
												enchantmentGetter.getOrThrow(enchantment),
												MinMaxBounds.Ints.ANY
										)
								)
						)
				);
		*///?}
	}

	private static @NotNull Matcher getMaterialMatcher(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
		return Matcher.forMaterial(materialGetter.getOrThrow(material), 1);
	}

	static Iterable<TrimProperty> getProperties(Level level) {
		return level.registryAccess()
				.lookupOrThrow(BetterTrimsRegistries.Keys.TRIM_PROPERTIES)
				.listElements()
				.map(Holder.Reference::value)::iterator;
	}

	private static void register(BootstrapContext<TrimProperty> context, ResourceKey<TrimProperty> key, TrimProperty property) {
		context.register(key, property);
	}

	private static ResourceKey<TrimProperty> key(String key) {
		return ResourceKey.create(BetterTrimsRegistries.Keys.TRIM_PROPERTIES, BetterTrims.rl(key));
	}
}
