/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeComponent;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public final class CyclingComponent
implements CompositeComponent {
    private final List<ClientTooltipComponent> components;
    private int index = 0;
    private int frameCounter = 0;

    public CyclingComponent(List<ClientTooltipComponent> components) {
        this.components = components;
    }

    @Override
    public List<ClientTooltipComponent> getComponents() {
        return this.components;
    }

    public int getHeight(Font font) {
        return this.components.get(this.index).getHeight(font);
    }

    public int getWidth(@NotNull Font font) {
        return this.components.get(this.index).getWidth(font);
    }

    public void renderText(GuiGraphics graphics, Font font, int x, int y) {
        if (this.components.isEmpty()) {
            return;
        }
        if (this.frameCounter++ >= Minecraft.getInstance().getFps()) {
            this.frameCounter = 0;
            this.index = (this.index + 1) % this.components.size();
        }
        this.components.get(this.index).renderText(graphics, font, x, y);
    }

    public void renderImage(@NotNull Font font, int x, int y, int width, int height, @NotNull GuiGraphics graphics) {
        if (this.components.isEmpty()) {
            return;
        }
        this.components.get(this.index).renderImage(font, x, y, width, height, graphics);
    }

    public int size() {
        return this.components.size();
    }

    public ClientTooltipComponent get(int index) {
        return this.components.get(index);
    }

    public String toString() {
        return "Cycling{%s}".formatted(this.components);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CompositeBuilder<CyclingComponent> {
        public Builder component(ClientTooltipComponent component) {
            return (Builder)super.component(component);
        }

        public Builder textComponent(Component component) {
            return (Builder)super.textComponent(component);
        }

        public Builder translate(String key, Object ... args) {
            return (Builder)super.translate(key, args);
        }

        public Builder translate(String key, UnaryOperator<Style> styler, Object ... args) {
            return (Builder)super.translate(key, styler, args);
        }

        public Builder literal(String text) {
            return (Builder)super.literal(text);
        }

        public Builder literal(String text, UnaryOperator<Style> styler) {
            return (Builder)super.literal(text, styler);
        }

        public Builder space() {
            return (Builder)super.space();
        }

        @Override
        public CyclingComponent build() {
            return new CyclingComponent(this.components);
        }
    }
}

