/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.mixin;

import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ClientTextTooltip.class})
abstract class ClientTextTooltipMixin {
    @Shadow
    @Final
    private FormattedCharSequence text;

    ClientTextTooltipMixin() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("\"");
        this.text.accept((i, style, codepoint) -> {
            builder.appendCodePoint(codepoint);
            return true;
        });
        builder.append("\"");
        return builder.toString();
    }

    public int hashCode() {
        AtomicLong hash = new AtomicLong();
        this.text.accept((i, style, codepoint) -> {
            hash.getAndUpdate(h -> 31L * h + (long)codepoint ^ (long)style.hashCode() + 31L * (long)i);
            return true;
        });
        return (int)hash.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientTextTooltip)) {
            return false;
        }
        ClientTextTooltip other = (ClientTextTooltip)obj;
        return other.hashCode() == this.hashCode();
    }
}

