/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.client.mixin.accessor.ClientTextTooltipAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;

public final class TooltipComponentOptimiser {
    private static final CompositeContainerComponent EMPTY = CompositeContainerComponent.builder().build();
    private static final List<Pass> OPTIMISATION_PASSES = List.of(TooltipComponentOptimiser::flatten, TooltipComponentOptimiser::flattenHorizontal, TooltipComponentOptimiser::flattenVertical, TooltipComponentOptimiser::mergeTextTooltips);
    private static final List<Pass> FINAL_PASSES = List.of(TooltipComponentOptimiser::clearHorizontalOffsets, TooltipComponentOptimiser::setPropertVerticalOffsets);

    private TooltipComponentOptimiser() {
    }

    public static ClientTooltipComponent optimise(CompositeComponent component, Font font) {
        if (component == null || component.getComponents().isEmpty()) {
            return EMPTY;
        }
        CompositeComponent current = component;
        for (int i = 0; i < 2; ++i) {
            for (Pass pass : OPTIMISATION_PASSES) {
                current = pass.apply(current, font);
            }
        }
        for (Pass pass : FINAL_PASSES) {
            current = pass.apply(current, font);
        }
        return current;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClientTooltipComponent flatten(ClientTooltipComponent component, Font font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::flatten);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::flatten);
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            if (container.getComponents().size() == 1) {
                ClientTooltipComponent single = container.getComponents().getFirst();
                return TooltipComponentOptimiser.flatten(single, font);
            }
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
        }
        Iterator<ClientTooltipComponent> iterator = composite.getComponents().iterator();
        block6: while (iterator.hasNext()) {
            ClientTooltipComponent clientTooltipComponent;
            ClientTooltipComponent child = iterator.next();
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConditionalComponent.class, CompositeComponent.class}, (Object)clientTooltipComponent, n)) {
                case 0: {
                    ConditionalComponent conditionalComponent = (ConditionalComponent)clientTooltipComponent;
                    try {
                        Object object;
                        ClientTooltipComponent ifTrue = object = conditionalComponent.ifTrue();
                        ClientTooltipComponent ifFalse = object = conditionalComponent.ifFalse();
                        Object checker = object = conditionalComponent.checker();
                        builder.component(new ConditionalComponent(TooltipComponentOptimiser.flatten(ifTrue, font), TooltipComponentOptimiser.flatten(ifFalse, font), (Supplier<Boolean>)checker));
                        continue block6;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    CompositeComponent cc = (CompositeComponent)clientTooltipComponent;
                    builder.component(TooltipComponentOptimiser.flatten(cc, font));
                    continue block6;
                }
            }
            builder.component(TooltipComponentOptimiser.flatten(child, font));
        }
        return builder.build();
    }

    /*
     * Loose catch block
     */
    private static ClientTooltipComponent mergeTextTooltips(ClientTooltipComponent component, Font font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::mergeTextTooltips);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::mergeTextTooltips);
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
        }
        TextMerger merger = new TextMerger(composite instanceof CompositeContainerComponent.Vertical);
        block8: for (ClientTooltipComponent child : composite.getComponents()) {
            ClientTooltipComponent clientTooltipComponent;
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientTextTooltip.class, ConditionalComponent.class}, (Object)clientTooltipComponent, n)) {
                case 0: {
                    ClientTextTooltip text = (ClientTextTooltip)clientTooltipComponent;
                    merger.add(text);
                    continue block8;
                }
                case 1: {
                    Object object;
                    ConditionalComponent conditionalComponent = (ConditionalComponent)clientTooltipComponent;
                    ClientTooltipComponent ifTrue = object = conditionalComponent.ifTrue();
                    ClientTooltipComponent ifFalse = object = conditionalComponent.ifFalse();
                    Object checker = object = conditionalComponent.checker();
                    merger.flush(builder);
                    builder.component(new ConditionalComponent(TooltipComponentOptimiser.mergeTextTooltips(ifTrue, font), TooltipComponentOptimiser.mergeTextTooltips(ifFalse, font), (Supplier<Boolean>)checker));
                    continue block8;
                }
            }
            merger.flush(builder);
            builder.component(TooltipComponentOptimiser.mergeTextTooltips(child, font));
        }
        merger.flush(builder);
        return builder.build();
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static ClientTooltipComponent flattenHorizontal(ClientTooltipComponent component, Font font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::flattenHorizontal);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::flattenHorizontal);
        }
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            } else if (container instanceof CompositeContainerComponent.Horizontal) {
                builder.horizontal();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
            for (ClientTooltipComponent child : container.getComponents()) {
                ClientTooltipComponent flattenedChild = TooltipComponentOptimiser.flattenHorizontal(child, font);
                if (container instanceof CompositeContainerComponent.Horizontal && flattenedChild instanceof CompositeContainerComponent.Horizontal) {
                    CompositeContainerComponent.Horizontal nested = (CompositeContainerComponent.Horizontal)flattenedChild;
                    for (ClientTooltipComponent grandChild : nested.getComponents()) {
                        builder.component(grandChild);
                    }
                    continue;
                }
                builder.component(flattenedChild);
            }
            return builder.build();
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        for (ClientTooltipComponent child : composite.getComponents()) {
            builder.component(TooltipComponentOptimiser.flattenHorizontal(child, font));
        }
        return builder.build();
    }

    private static ClientTooltipComponent flattenVertical(ClientTooltipComponent component, Font font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::flattenVertical);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::flattenVertical);
        }
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            } else if (container instanceof CompositeContainerComponent.Horizontal) {
                builder.horizontal();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
            for (ClientTooltipComponent child : container.getComponents()) {
                ClientTooltipComponent flattenedChild = TooltipComponentOptimiser.flattenVertical(child, font);
                if (container instanceof CompositeContainerComponent.Vertical && flattenedChild instanceof CompositeContainerComponent.Vertical) {
                    CompositeContainerComponent.Vertical nested = (CompositeContainerComponent.Vertical)flattenedChild;
                    for (ClientTooltipComponent grandChild : nested.getComponents()) {
                        builder.component(grandChild);
                    }
                    continue;
                }
                builder.component(flattenedChild);
            }
            return builder.build();
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        for (ClientTooltipComponent child : composite.getComponents()) {
            builder.component(TooltipComponentOptimiser.flattenVertical(child, font));
        }
        return builder.build();
    }

    public static ClientTooltipComponent clearHorizontalOffsets(ClientTooltipComponent root, Font font) {
        return TooltipComponentOptimiser.clearHorizontalOffsets(root, font, 0, 0, 0);
    }

    private static ClientTooltipComponent clearHorizontalOffsets(ClientTooltipComponent component, Font font, int absX, int anchorAbsX, int verticalDepth) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, (c, f) -> TooltipComponentOptimiser.clearHorizontalOffsets(c, f, absX, anchorAbsX, verticalDepth));
        }
        CompositeComponent composite = (CompositeComponent)component;
        CompositeComponent compositeComponent = composite;
        Objects.requireNonNull(compositeComponent);
        CompositeComponent compositeComponent2 = compositeComponent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CyclingComponent.class, CompositeContainerComponent.Horizontal.class, CompositeContainerComponent.Vertical.class}, (Object)compositeComponent2, n)) {
            case 0: {
                CyclingComponent cycling = (CyclingComponent)compositeComponent2;
                return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, (c, f) -> TooltipComponentOptimiser.clearHorizontalOffsets(c, f, absX, anchorAbsX, verticalDepth));
            }
            case 1: {
                CompositeContainerComponent.Horizontal horizontal = (CompositeContainerComponent.Horizontal)compositeComponent2;
                int runningX = 0;
                for (ClientTooltipComponent child : horizontal.getComponents()) {
                    int childAbsX = absX + runningX;
                    TooltipComponentOptimiser.clearChildHorizontalOffsets(font, anchorAbsX, verticalDepth, child, childAbsX);
                    runningX += child.getWidth(font);
                }
                return composite;
            }
            case 2: {
                CompositeContainerComponent.Vertical vertical = (CompositeContainerComponent.Vertical)compositeComponent2;
                vertical.setHorizontalOffset(absX - anchorAbsX);
                List<ClientTooltipComponent> children = vertical.getComponents();
                for (int i = 0; i < children.size(); ++i) {
                    ClientTooltipComponent child = children.get(i);
                    int childAbsX = i == 0 ? absX : anchorAbsX;
                    TooltipComponentOptimiser.clearChildHorizontalOffsets(font, anchorAbsX, verticalDepth, child, childAbsX);
                }
                return vertical;
            }
        }
        int runningX = 0;
        for (ClientTooltipComponent child : composite.getComponents()) {
            int childAbsX = absX + runningX;
            TooltipComponentOptimiser.clearHorizontalOffsets(child, font, childAbsX, anchorAbsX, verticalDepth);
            runningX += child.getWidth(font);
        }
        return composite;
    }

    private static void clearChildHorizontalOffsets(Font font, int anchorAbsX, int verticalDepth, ClientTooltipComponent child, int childAbsX) {
        if (child instanceof CompositeContainerComponent.Vertical) {
            CompositeContainerComponent.Vertical nestedVert = (CompositeContainerComponent.Vertical)child;
            nestedVert.setHorizontalOffset(childAbsX - anchorAbsX);
            TooltipComponentOptimiser.clearHorizontalOffsets(nestedVert, font, childAbsX, anchorAbsX, verticalDepth + 1);
        } else if (child instanceof CompositeContainerComponent.Horizontal) {
            CompositeContainerComponent.Horizontal horChild = (CompositeContainerComponent.Horizontal)child;
            TooltipComponentOptimiser.clearHorizontalOffsets(horChild, font, childAbsX, anchorAbsX, verticalDepth);
        } else {
            TooltipComponentOptimiser.clearHorizontalOffsets(child, font, childAbsX, anchorAbsX, verticalDepth);
        }
    }

    private static ClientTooltipComponent setPropertVerticalOffsets(ClientTooltipComponent clientTooltipComponent, Font font) {
        return TooltipComponentOptimiser.setProperVerticalOffsets(clientTooltipComponent, font, 0);
    }

    private static ClientTooltipComponent setProperVerticalOffsets(ClientTooltipComponent component, Font font, int verticalDepth) {
        int initialDepth = verticalDepth;
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, (c, f) -> TooltipComponentOptimiser.setProperVerticalOffsets(c, f, initialDepth));
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, (c, f) -> TooltipComponentOptimiser.setProperVerticalOffsets(c, f, initialDepth));
        }
        if (composite instanceof CompositeContainerComponent.Vertical) {
            CompositeContainerComponent.Vertical vertical = (CompositeContainerComponent.Vertical)composite;
            vertical.setHorizontalOffset(vertical.getHorizontalOffset() - verticalDepth * font.width("  "));
            ++verticalDepth;
        }
        for (ClientTooltipComponent child : composite.getComponents()) {
            TooltipComponentOptimiser.setProperVerticalOffsets(child, font, verticalDepth);
        }
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ClientTooltipComponent forwardPassToNonComposite(ClientTooltipComponent component, Font font, Pass pass) {
        ClientTooltipComponent ifTrue;
        Object object;
        if (!(component instanceof ConditionalComponent)) return component;
        ConditionalComponent conditionalComponent = (ConditionalComponent)component;
        try {
            ifTrue = object = conditionalComponent.ifTrue();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ClientTooltipComponent ifFalse = object = conditionalComponent.ifFalse();
        Object checker = object = conditionalComponent.checker();
        return new ConditionalComponent(pass.apply(ifTrue, font), pass.apply(ifFalse, font), (Supplier<Boolean>)checker);
    }

    private static CyclingComponent forwardPassToCycling(CyclingComponent cycling, Font font, Pass pass) {
        CyclingComponent.Builder cyclingBuilder = CyclingComponent.builder();
        for (ClientTooltipComponent child : cycling.getComponents()) {
            cyclingBuilder.component(pass.apply(child, font));
        }
        return cyclingBuilder.build();
    }

    static interface Pass {
        public ClientTooltipComponent apply(ClientTooltipComponent var1, Font var2);
    }

    private static class TextMerger {
        private final List<ClientTextTooltip> buffer = new ArrayList<ClientTextTooltip>();
        private final boolean isVertical;

        public TextMerger(boolean isVertical) {
            this.isVertical = isVertical;
        }

        void add(ClientTextTooltip text) {
            this.buffer.add(text);
        }

        void flush(CompositeContainerComponent.Builder builder) {
            if (this.buffer.isEmpty()) {
                return;
            }
            if (this.buffer.size() == 1) {
                builder.component((ClientTooltipComponent)this.buffer.getFirst());
            } else if (!this.isVertical) {
                builder.component((ClientTooltipComponent)this.mergeAll(this.buffer));
            } else {
                this.buffer.forEach(builder::component);
            }
            this.buffer.clear();
        }

        private ClientTextTooltip mergeAll(List<ClientTextTooltip> tooltips) {
            MutableComponent combined = Component.empty();
            var ref = new Object(this){
                Style currentStyle = null;
            };
            StringBuilder sb = new StringBuilder();
            FormattedCharSink sink = (index, style, codepoint) -> {
                if (ref.currentStyle == null) {
                    ref.currentStyle = style;
                }
                if (!style.equals((Object)ref.currentStyle)) {
                    if (!sb.isEmpty()) {
                        combined.append((Component)Component.literal((String)sb.toString()).withStyle(ref.currentStyle));
                        sb.setLength(0);
                    }
                    ref.currentStyle = style;
                }
                sb.appendCodePoint(codepoint);
                return true;
            };
            for (ClientTextTooltip t : tooltips) {
                ((ClientTextTooltipAccessor)t).bettertrims$text().accept(sink);
            }
            if (!sb.isEmpty()) {
                combined.append((Component)Component.literal((String)sb.toString()).withStyle(ref.currentStyle));
            }
            return new ClientTextTooltip(combined.getVisualOrderText());
        }
    }
}

