/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.DataComponentMatchersTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Optional;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;

public interface ItemPredicateTooltip {
    public static void addToBuilder(ClientLevel level, ItemPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Ints count;
        DataComponentMatchers components;
        Optional items = predicate.items();
        if (items.isPresent()) {
            ItemPredicateTooltip.addItemsToBuilder(level, (HolderSet<Item>)((HolderSet)items.orElseThrow()), state, builder);
            state = state.withUseWith(true);
        }
        if (!(components = predicate.components()).isEmpty()) {
            ItemPredicateTooltip.addDataComponentMatchersToBuilder(level, components, state, builder);
        }
        if (!(count = predicate.count()).isAny()) {
            ItemPredicateTooltip.addCountToBuilder(level, count, state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("item.%s".formatted(key));
    }

    public static void addItemsToBuilder(ClientLevel level, HolderSet<Item> items, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, ItemPredicateTooltip.key("matches"), Registries.ITEM, items, item -> item.getName(), state, builder);
    }

    public static void addDataComponentMatchersToBuilder(ClientLevel level, DataComponentMatchers components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (state.doPrefixSpace()) {
            builder.space();
        }
        builder.translate("bettertrims.tooltip.condition.match_tool.has.%s".formatted(state.key()), Styler::condition, new Object[0]);
        DataComponentMatchersTooltip.addToBuilder(level, components, state, builder);
    }

    public static void addCountToBuilder(ClientLevel level, MinMaxBounds.Ints count, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent.Builder countBuilder = CompositeContainerComponent.builder().space();
        PredicateTooltip.addMinMaxToBuilder(ItemPredicateTooltip.key("count"), false, count, state, countBuilder);
        builder.component(countBuilder.build());
    }
}

