/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.context;

import com.bawnorton.bettertrims.property.context.TrimContextParamSets;
import com.bawnorton.bettertrims.property.context.TrimContextParams;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class TrimContexts {
    public static LootContext damage(ServerLevel level, TrimmedItems items, Entity entity, DamageSource damageSource, ItemStack damagingItem) {
        return new LootContext.Builder(new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(TrimContextParams.ITEMS, (Object)items).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity()).withOptionalParameter(LootContextParams.TOOL, (Object)damagingItem).create(TrimContextParamSets.TRIM_DAMAGE)).create(Optional.empty());
    }

    public static LootContext damage(ServerLevel level, TrimmedItems items, Entity entity, DamageSource damageSource) {
        ItemStack damagingItem = null;
        Entity entity2 = damageSource.getDirectEntity();
        if (entity2 instanceof AbstractArrow) {
            AbstractArrow abstractArrow = (AbstractArrow)entity2;
            damagingItem = abstractArrow.getPickupItemStackOrigin();
        }
        return TrimContexts.damage(level, items, entity, damageSource, damagingItem);
    }

    public static LootContext damageItem(ServerLevel level, ItemStack item, @Nullable ItemEntity entity, DamageSource damageSource) {
        return new LootContext.Builder(new LootParams.Builder(level).withParameter(LootContextParams.TOOL, (Object)item).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ORIGIN, (Object)(entity == null ? null : entity.position())).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity()).create(TrimContextParamSets.TRIM_ITEM_DAMAGE)).create(Optional.empty());
    }

    public static LootContext equipment(ServerLevel level, TrimmedItems items, @Nullable ItemStack heldItem) {
        return new LootContext.Builder(new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)items.owner()).withParameter(LootContextParams.ORIGIN, (Object)items.owner().position()).withParameter(TrimContextParams.ITEMS, (Object)items).withOptionalParameter(LootContextParams.TOOL, (Object)heldItem).create(TrimContextParamSets.TRIM_EQUIPMENT)).create(Optional.empty());
    }

    public static LootContext equipment(ServerLevel level, TrimmedItems items) {
        return TrimContexts.equipment(level, items, null);
    }

    public static LootContext entity(ServerLevel level, TrimmedItems items, Entity entity, Vec3 origin) {
        return new LootContext.Builder(new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(TrimContextParams.ITEMS, (Object)items).withParameter(LootContextParams.ORIGIN, (Object)origin).create(TrimContextParamSets.TRIM_ENTITY)).create(Optional.empty());
    }

    public static LootContext blockHitWithHeld(ServerLevel level, TrimmedItems items, Entity entity, Vec3 origin, BlockState state, ItemStack heldItem) {
        return new LootContext.Builder(new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(TrimContextParams.ITEMS, (Object)items).withParameter(LootContextParams.ORIGIN, (Object)origin).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.TOOL, (Object)heldItem).create(TrimContextParamSets.HIT_BLOCK_WITH_HELD_ITEM)).create(Optional.empty());
    }
}

