/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public interface CompositeComponent
extends DynamicWidthComponent {
    public List<ClientTooltipComponent> getComponents();

    @Override
    default public int getMaxWidth(Font font) {
        int maxWidth = 0;
        for (ClientTooltipComponent component : this.getComponents()) {
            maxWidth = DynamicWidthComponent.getMaxWidth(font, component, maxWidth);
        }
        return maxWidth;
    }

    @Override
    default public int getMinWidth(Font font) {
        int minWidth = Integer.MAX_VALUE;
        for (ClientTooltipComponent component : this.getComponents()) {
            minWidth = DynamicWidthComponent.getMinWidth(font, component, minWidth);
        }
        return minWidth;
    }

    default public boolean isOneLine() {
        for (ClientTooltipComponent component : this.getComponents()) {
            CompositeComponent composite;
            if (!(component instanceof CompositeComponent) || (composite = (CompositeComponent)component).isOneLine()) continue;
            return false;
        }
        return true;
    }
}

