/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.version.VRegistry;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.GameTypePredicate;
import net.minecraft.advancements.critereon.InputPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.GameType;

public interface PlayerPredicateTooltip {
    public static void addToBuilder(ClientLevel level, PlayerPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional input;
        MinMaxBounds.Ints playerLevel = predicate.level();
        PlayerPredicateTooltip.addLevelToBuilder(level, playerLevel, state, builder);
        GameTypePredicate gameType = predicate.gameType();
        PlayerPredicateTooltip.addGameTypeToBuilder(level, gameType, state, builder);
        List stats = predicate.stats();
        PlayerPredicateTooltip.addStatsToBuilder(level, stats, state, builder);
        Object2BooleanMap recipes = predicate.recipes();
        PlayerPredicateTooltip.addRecipesToBuilder(level, recipes, state, builder);
        Map advancements = predicate.advancements();
        PlayerPredicateTooltip.addAdvancementsToBuilder(level, advancements, state, builder);
        Optional lookingAt = predicate.lookingAt();
        if (lookingAt.isPresent()) {
            PlayerPredicateTooltip.addLookingAtToBuilder(level, (EntityPredicate)lookingAt.orElseThrow(), state, builder);
        }
        if ((input = predicate.input()).isPresent()) {
            PlayerPredicateTooltip.addInputToBuilder(level, (InputPredicate)input.orElseThrow(), state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("player.%s".formatted(key));
    }

    public static void addLevelToBuilder(ClientLevel level, MinMaxBounds.Ints playerLevel, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (!playerLevel.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(PlayerPredicateTooltip.key("level"), false, playerLevel, state, builder);
        }
    }

    public static void addGameTypeToBuilder(ClientLevel level, GameTypePredicate gameType, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        List types = gameType.types();
        if (!types.isEmpty()) {
            PredicateTooltip.addEnumListToBuilder(PlayerPredicateTooltip.key("game_type"), types, GameType::getShortDisplayName, state, builder);
        }
    }

    public static void addStatsToBuilder(ClientLevel level, List<PlayerPredicate.StatMatcher<?>> stats, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (stats.isEmpty()) {
            return;
        }
        CompositeContainerComponent.Builder statsBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("stats.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> {
            for (PlayerPredicate.StatMatcher stat : stats) {
                CompositeContainerComponent.Builder cycledBuilder = CompositeContainerComponent.builder();
                cycledBuilder.textComponent((Component)Component.translatable((String)PlayerPredicateTooltip.key("stat"), (Object[])new Object[]{Styler.name(stat.type().getDisplayName().copy())})).space().literal("[", Styler::condition);
                PredicateTooltip.addMinMaxToBuilder(PlayerPredicateTooltip.key("stat.range"), false, stat.range(), state, cycledBuilder);
                cycledBuilder.literal("]", Styler::condition);
                cycleBuilder.component(cycledBuilder.build());
            }
        });
        builder.component(statsBuilder.build());
    }

    public static void addRecipesToBuilder(ClientLevel level, Object2BooleanMap<ResourceKey<Recipe<?>>> recipes, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (recipes.isEmpty()) {
            return;
        }
        CompositeContainerComponent.Builder recipesBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("recipes.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> recipes.object2BooleanEntrySet().forEach(entry -> {
            boolean knows = entry.getBooleanValue();
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            MutableComponent name = Styler.name(Component.literal((String)id.toString()));
            cycleBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(PlayerPredicateTooltip.key("recipe.%s".formatted(knows ? "knows" : "does_not_know")), Styler::condition, new Object[]{name})).build());
        }));
        builder.component(recipesBuilder.build());
    }

    public static void addAdvancementsToBuilder(ClientLevel level, Map<ResourceLocation, PlayerPredicate.AdvancementPredicate> advancements, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (advancements.isEmpty()) {
            return;
        }
        Registry registry = VRegistry.get(level, Registries.ADVANCEMENT);
        CompositeContainerComponent.Builder advancementsBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("advancements.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> advancements.forEach((id, advancementPredicate) -> {
            Advancement advancement = registry.getOptional(id).orElse(null);
            if (advancement == null) {
                return;
            }
            MutableComponent name = Styler.name(((Component)advancement.name().orElse(Component.literal((String)id.toString()))).copy());
            CompositeContainerComponent.Builder advancementBuilder = CompositeContainerComponent.builder().textComponent((Component)name);
            PlayerPredicate.AdvancementPredicate advancementPredicate2 = advancementPredicate;
            Objects.requireNonNull(advancementPredicate2);
            PlayerPredicate.AdvancementPredicate selector0$temp = advancementPredicate2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlayerPredicate.AdvancementDonePredicate.class, PlayerPredicate.AdvancementCriterionsPredicate.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    PlayerPredicate.AdvancementDonePredicate donePredicate = (PlayerPredicate.AdvancementDonePredicate)selector0$temp;
                    boolean isDone = donePredicate.state();
                    advancementBuilder.translate(PlayerPredicateTooltip.key("advancement.%s".formatted(isDone ? "completed" : "not_completed")), Styler::value, new Object[0]);
                    break;
                }
                case 1: {
                    PlayerPredicate.AdvancementCriterionsPredicate criterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)selector0$temp;
                    Object2BooleanMap criterions = criterionsPredicate.criterions();
                    if (criterions.isEmpty()) break;
                    advancementBuilder.space().literal("[");
                    boolean useAnd = false;
                    for (Map.Entry entry : criterions.object2BooleanEntrySet()) {
                        if (useAnd) {
                            advancementBuilder.literal(" & ");
                        }
                        useAnd = true;
                        String criterion = (String)entry.getKey();
                        boolean achieved = (Boolean)entry.getValue();
                        advancementBuilder.translate(PlayerPredicateTooltip.key("advancement.criterion.%s".formatted(achieved ? "achieved" : "not_achieved")), Styler::value, new Object[]{Styler.name(Component.literal((String)criterion))});
                    }
                    advancementBuilder.literal("]");
                    break;
                }
            }
            cycleBuilder.component(advancementBuilder.build());
        }));
        builder.component(advancementsBuilder.build());
    }

    public static void addLookingAtToBuilder(ClientLevel level, EntityPredicate entityPredicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        EntityPredicateTooltip.addEntityPredicateToBuilder(level, "looking_at", entityPredicate, state, builder);
    }

    public static void addInputToBuilder(ClientLevel level, InputPredicate inputPredicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map<String, Optional> inputs = Map.of("forward", inputPredicate.forward(), "backward", inputPredicate.backward(), "left", inputPredicate.left(), "right", inputPredicate.right(), "jump", inputPredicate.jump(), "sneak", inputPredicate.sneak(), "sprint", inputPredicate.sprint());
        CompositeContainerComponent.Builder inputBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(PlayerPredicateTooltip.key("input.matches"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> inputs.forEach((inputName, input) -> {
            if (input.isPresent()) {
                boolean isHeld = input.orElse(false);
                cycleBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(PlayerPredicateTooltip.key("input.%s.%s".formatted(inputName, isHeld ? "true" : "false")), Styler::value, new Object[0])).build());
            }
        }));
        builder.component(inputBuilder.build());
    }
}

