/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.ability.damage_immunity;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ConditionalElementMatcher;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Iterator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EnchantmentHelper.class})
abstract class EnchantmentHelperMixin {
    EnchantmentHelperMixin() {
    }

    @ModifyReturnValue(method={"isImmuneToDamage"}, at={@At(value="RETURN")})
    private static boolean isTrimInvulnerableTo(boolean original, ServerLevel level, LivingEntity entity, DamageSource damageSource) {
        if (original) {
            return true;
        }
        for (TrimProperty property : TrimProperties.getProperties((Level)level)) {
            Iterator<ConditionalElementMatcher<?>> iterator = property.getAbilityElements(TrimAbilityComponents.DAMAGE_IMMUNITY).iterator();
            if (!iterator.hasNext()) continue;
            ElementMatcher ability = iterator.next();
            return ability.matches(entity, TrimContexts.damage(level, ability.getMatchingItems(entity), (Entity)entity, damageSource));
        }
        return false;
    }
}

