/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record SetBlockPropertiesAbility(BlockItemStateProperties properties, Vec3i offset, Optional<Holder<GameEvent>> triggerGameEvent, String propertiesTranslationKey, String offsetTranslationKey) implements TrimEntityAbility
{
    public static final MapCodec<SetBlockPropertiesAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockItemStateProperties.CODEC.fieldOf("properties").forGetter(SetBlockPropertiesAbility::properties), (App)Vec3i.CODEC.optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(SetBlockPropertiesAbility::offset), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(SetBlockPropertiesAbility::triggerGameEvent), (App)Codec.STRING.fieldOf("properties_translation_key").forGetter(SetBlockPropertiesAbility::propertiesTranslationKey), (App)Codec.STRING.fieldOf("offset_translation_key").forGetter(SetBlockPropertiesAbility::offsetTranslationKey)).apply((Applicative)instance, SetBlockPropertiesAbility::new));

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        BlockState newState;
        BlockPos blockPos = BlockPos.containing((Position)origin).offset(this.offset);
        BlockState currentState = level.getBlockState(blockPos);
        if (currentState != (newState = this.properties.apply(currentState)) && level.setBlock(blockPos, newState, 3)) {
            this.triggerGameEvent.ifPresent(holder -> level.gameEvent((Entity)wearer, holder, blockPos));
        }
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<SetBlockPropertiesAbility> {
        @Override
        @Nullable
        public ClientTooltipComponent getTooltip(ClientLevel level, SetBlockPropertiesAbility element, boolean includeCount) {
            MutableComponent properties = Styler.property(Component.translatable((String)element.propertiesTranslationKey));
            MutableComponent offset = Styler.positive(Component.translatable((String)element.offsetTranslationKey));
            return ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.set_block_properties.set", Styler::positive, new Object[0])).textComponent((Component)properties).textComponent((Component)offset).spaced().build();
        }
    }
}

